//	File:			SI_YT1.inc
//	Product:		SIMATIC PDM
//	Description:	include for trendviewer with one - four variables
//  $Revision:   1.2  $	
//  $Date:   Jan 26 2000 14:39:26  $
//	Copyright (C) Siemens AG (1998). All Rights Reserved


// Parameter: YT1_VALUE, YT1_URV, YT1_LRV, YT1_LABEL
// Parameter: YT2_VALUE, YT2_URV, YT2_LRV, YT2_LABEL
// Parameter: YT3_VALUE, YT3_URV, YT3_LRV, YT3_LABEL
// Parameter: YT4_VALUE, YT4_URV, YT4_LRV, YT4_LABEL


#ifndef _V50_ 

#define OnlineWindow_yt_AVAILABLE


MENU OnlineWindow_yt
{
	LABEL		[menu_yt_diagram] ;
	ITEMS
	{
			Page_yt_unavailable
	}
}

MENU Page_yt_unavailable
{
	LABEL		[menu_yt_diagram] ;
	ITEMS
	{
		Bar_yt_unavailable
	}
}

MENU Bar_yt_unavailable
{
	LABEL "Y t diagram not available !" "|de|Verlaufskurve nicht verfgbar !";
	ITEMS
	{
		YT1_VALUE
	}
}

#else

MENU OnlineWindow_yt
{
	LABEL		[menu_yt_diagram] ;
	ITEMS
	{
			Page_process_yt
	}
}

MENU Page_process_yt
{
	LABEL		[menu_yt_diagram] ;
	ITEMS
	{
		Val_yt,

#ifdef YT2_LABEL
		Val_yt2,
#endif
#ifdef YT3_LABEL
		Val_yt3,
#endif
#ifdef YT4_LABEL
		Val_yt4,
#endif

		OCX_out_display_yt
	}
}


MENU Val_yt
{
    LABEL YT1_LABEL ;

#ifdef YT1_HELP
	HELP YT1_HELP ;
#endif

	ITEMS
	{
		YT1_VALUE				(READ_ONLY)
	}
}


#ifdef YT2_LABEL
MENU Val_yt2
{
    LABEL YT2_LABEL ;

#ifdef YT2_HELP
	HELP YT2_HELP ;
#endif

	ITEMS
	{
		YT2_VALUE				(READ_ONLY)
	}
}
#endif

#ifdef YT3_LABEL
MENU Val_yt3
{
    LABEL YT3_LABEL ;

#ifdef YT3_HELP
	HELP YT3_HELP ;
#endif

	ITEMS
	{
		YT3_VALUE				(READ_ONLY)
	}
}
#endif

#ifdef YT4_LABEL
MENU Val_yt4
{
    LABEL YT4_LABEL ;

#ifdef YT4_HELP
	HELP YT4_HELP ;
#endif

	ITEMS
	{
		YT4_VALUE				(READ_ONLY)
	}
}
#endif


MENU OCX_out_display_yt								// OCX-Control
{
	LABEL		[menu_yt_diagram] ;
	HELP		[trendview_help] ;
	STYLE		"PDMTVPROXY.PDMTVProxyCtrl.1";		// Name, unter dem das OCX in Windows registriert ist
	ITEMS
	{
		OCX_ProfilNum_yt,							// Profil-Nummer

		OCX_out_display_1,							// 1. Kurve

#ifdef YT2_LABEL
		OCX_out_display_2,							// 2. Kurve
#endif

#ifdef YT3_LABEL
		OCX_out_display_3,							// 3. Kurve
#endif

#ifdef YT4_LABEL
		OCX_out_display_4,							// 4. Kurve
#endif

		OCX_UserSettings_yt		// Fr Speicherung von Settings, die vom Benutzer zur Laufzeit gendert wurden
	}
}


MENU OCX_out_display_1								// 1. Kurve im OCX-Control yt
{
    LABEL YT1_LABEL ;
	STYLE		"OCX_DYNAMIC_YT";
	ITEMS
	{
		YT1_VALUE	(READ_ONLY),
		YT1_LRV		(READ_ONLY),
		YT1_URV		(READ_ONLY)
	}
}


#ifdef YT2_LABEL
MENU OCX_out_display_2								// 2. Kurve im OCX-Control yt
{
    LABEL YT2_LABEL ;
	STYLE		"OCX_DYNAMIC_YT";
	ITEMS
	{
		YT2_VALUE	(READ_ONLY),
		YT2_LRV		(READ_ONLY),
		YT2_URV		(READ_ONLY)
	}
}
#endif


#ifdef YT3_LABEL
MENU OCX_out_display_3								// 3. Kurve im OCX-Control yt
{
    LABEL YT3_LABEL ;
	STYLE		"OCX_DYNAMIC_YT";
	ITEMS
	{
		YT3_VALUE	(READ_ONLY),
		YT3_LRV		(READ_ONLY),
		YT3_URV		(READ_ONLY)
	}
}
#endif

#ifdef YT4_LABEL
MENU OCX_out_display_4								// 4. Kurve im OCX-Control yt
{
    LABEL YT4_LABEL ;
	STYLE		"OCX_DYNAMIC_YT";
	ITEMS
	{
		YT4_VALUE	(READ_ONLY),
		YT4_LRV		(READ_ONLY),
		YT4_URV		(READ_ONLY)
	}
}
#endif




VARIABLE OCX_ProfilNum_yt							// Profil-Variable fr OCX yt
{
	LABEL		"ProfilID";
	STYLE		"OCX_PROPERTY";
	CLASS		LOCAL;
	TYPE		INTEGER(2)
	{
#ifdef _V510_
		DEFAULT_VALUE 1004 ;	// mit Farbwahl
#else
		DEFAULT_VALUE	0;		// Profil 0 fr normale y-t-Darstellung
#endif

	}
	HANDLING    READ;
}

VARIABLE OCX_UserSettings_yt		// Fr Speicherung von Settings, die vom Benutzer zur Laufzeit gendert wurden
{
	LABEL		"UserSettings";
	STYLE		"OCX_PROPERTY";
	CLASS		LOCAL;
	TYPE		ASCII (1000)
	{
		DEFAULT_VALUE	"";
	}
	HANDLING	READ & WRITE;
}


#endif
// endif from _V50_
