/*

		DEVICE DESCRIPTION FOR KLAY SERIES 2000 AND SERIES 2000 SAN AND CER2000


		Date:					07-08-2006
		Author:				M.M. van de Belt
		Company:				Klay Instruments b.v. The Netherlands
		Filepath:			G:\electronica\projecten\Development\DD_DTM_FDT\Software\PDM\KLAY_PDM_HART_REV8
*/


/*
	Redefinition for manufacturer and devicetype
	Manufacturer: Klay Instruments
	Device: KLAY 2000 & KLAY 2000 SAN
	Device Revision: 1
	DD Revision: 2
*/


MANUFACTURER 117,
DEVICE_TYPE 0xef,
DEVICE_REVISION 1,
DD_REVISION 2


#define _COMMUNICATION_HART

#define PRIMARY 0
#define SECONDARY 1
#define TERTIARY 2
#define FOURTH 3


#define STATUS_RESPONSE_CODE 0
#define STATUS_COMM_STATUS  1
#define STATUS_DEVICE_STATUS 2
#define STATUS_SIZE 3





/* Some special text definitions */


#define H1LABEL SELECT(input_transfer_function)								\
{																							\
	CASE 1:                                 									\
      [h1_label_text];																\
   DEFAULT:                                									\
		[h1_label_text_default];      											\
}


#define H2DLABEL SELECT(input_transfer_function)							\
{																							\
	CASE 1:                                 									\
   	[h2d_label_text];  															\
   DEFAULT:                                									\
		[h2d_label_text_default];      											\
}



#define H2LLABEL SELECT(input_transfer_function)							\
{																							\
	CASE 1:                                 									\
   	[h2l_label_text];  															\
   DEFAULT:                                									\
		[h2l_label_text_default]; 													\
}



#define H3LABEL SELECT(input_transfer_function)								\
{																							\
	CASE 1:                                 									\
		[h3_label_text];  															\
   DEFAULT:                                									\
		[h3_label_text_default];      											\
}

/* End of special text definitions */




/*	Definiton of pressure units. These units depend on the klay_typecode
	of the transmitter */

#define KLAY_UNITS SELECT(klay_typecode)\
{\
			CASE 1:\
            { 	1, 	"InH20"	}, \
				{ 	2, 	"InHG"	}, \
            { 	4,		"mmH2O" 	}, \
            {	5,		"mmHG"	}, \
            {	6,		"PSI"		}, \
            {	7,		"bar"		}, \
				{	8,		"mbar"	}, \
            {	10,	"Kgf/cm"	}, \
            {	12,	"kPa"		}, \
				{	14,	"Atm"		}, \
				{ 240, "mH2O" }	/*mH20*/\
			CASE 2:\
            { 	1, 	"InH20"	}, \
				{ 	2, 	"InHG"	}, \
            { 	4,		"mmH2O" 	}, \
            {	5,		"mmHG"	}, \
            {	6,		"PSI"		}, \
            {	7,		"bar"		}, \
				{	8,		"mbar"	}, \
            {	10,	"Kgf/cm"	}, \
            {	12,	"kPa"		}, \
				{	14,	"Atm"		}, \
				{	237,	"MPa"		}, \
				{ 	240, "mH2O" }	/*mH20*/\
			CASE 8:\
            { 	1, 	"InH20"	}, \
				{ 	2, 	"InHG"	}, \
            { 	4,		"mmH2O" 	}, \
            {	5,		"mmHG"	}, \
            {	6,		"PSI"		}, \
            {	7,		"bar"		}, \
				{	8,		"mbar"	}, \
            {	10,	"Kgf/cm"	}, \
            {	12,	"kPa"		}, \
				{	14,	"Atm"		}, \
				{	237,	"MPa"		}, \
				{ 240, "mH2O" }	/*mH20*/\
			CASE 9:\
            {	6,		"PSI"		}, \
            {	7,		"bar"		}, \
            {	10,	"Kgf/cm"	}, \
				{	14,	"Atm"		}, \
				{	237,	"MPa"		}, \
				{ 240, "mH2O" }	/*mH20*/\
			DEFAULT:\
            { 	1, 	"InH20"	}, \
				{ 	2, 	"InHG"	}, \
            {	5,		"mmHG"	}, \
            {	6,		"PSI"		}, \
            {	7,		"bar"		}, \
				{	8,		"mbar"	}, \
            {	10,	"Kgf/cm"	}, \
            {	12,	"kPa"		}, \
				{	14,	"Atm"		}, \
				{	237,	"MPa"		}, \
				{ 240, "mH2O" }	/*mH20*/\
}


/*
	Definition for the display precision for the different klaytypecodes
	and units
*/


#define P_DISPLAY_PREC SELECT(klay_typecode) \
{				\
	CASE 1:	\
		SELECT (sensor_units)		\
		{ \
			CASE 1:		".1f";		\
			CASE 2:		".2f";		\
			CASE 4:		".f";			\
			CASE 5:		".1f";		\
			CASE 6:		".3f";		\
			CASE 7:		".3f";		\
			CASE 8:		".1f";		\
			CASE 10:		".3f";		\
			CASE 12:		".2f";		\
			CASE 14:		".3f";		\
			CASE 240: 	".3f";		\
		}									\
	CASE 2:								\
		SELECT (sensor_units)		\
		{ \
			CASE 1:		".1f";		\
			CASE 2:		".2f";		\
			CASE 4:		".f";			\
			CASE 5:		".1f";		\
			CASE 6:		".3f";		\
			CASE 7:		".3f";		\
			CASE 8:		".1f";		\
			CASE 10:		".3f";		\
			CASE 12:		".2f";		\
			CASE 14:		".3f";		\
			CASE 237:	".3f";		\
			CASE 240: 	".3f";		\
		}	\
	CASE 8:	\
		SELECT (sensor_units)		\
		{ \
			CASE 1:		".f";			\
			CASE 2:		".2f";		\
			CASE 4:		".f"; 		\
			CASE 5:		".f";			\
			CASE 6:		".2f";		\
			CASE 7:		".3f";		\
			CASE 8:		".1f";		\
			CASE 10:		".3f";		\
			CASE 12:		".1f";		\
			CASE 14:		".3f"; 		\
			CASE 237:	".3f";		\
			CASE 240: 	".2f";		\
		}	\
	CASE 9:	\
		SELECT (sensor_units)		\
		{ \
			CASE 6:		".1f";		\
			CASE 7:		".1f";		\
			CASE 10:		".1f";		\
			CASE 14:		".1f"; 		\
			CASE 237:	".1f";		\
			CASE 240: 	".1f";		\
		}	\
	DEFAULT:	\
		SELECT (sensor_units)		\
		{ \
			CASE 1:		".f";			\
			CASE 2:		".1f";		\
			CASE 5:		".f";			\
			CASE 6:		".1f";		\
			CASE 7:		".3f";		\
			CASE 8:		".f";			\
			CASE 10:		".3f";		\
			CASE 12:		".1f";		\
			CASE 14:		".3f"; 		\
			CASE 237:	".3f";		\
			CASE 240: 	".2f";		\
		}	\
}

/*
		Definition of the precision for input of floats
		It depends on typecode and units type
*/

#define P_EDIT_DISPLAY_PREC SELECT(klay_typecode) \
{ \
	CASE 1:	\
		SELECT (sensor_units)	\
		{ \
			CASE 1:		"6.1f";	\
			CASE 2:		"6.2f";	\
			CASE 4:		"4.f";	\
			CASE 5:		"6.1f";	\
			CASE 6:		"6.3f";	\
			CASE 7:		"6.3f";	\
			CASE 8:		"6.1f";	\
			CASE 10:		"6.3f";	\
			CASE 12:		"6.2f";	\
			CASE 14:		"6.3f";	\
			CASE 240: 	"6.3f"; 	\
		}	\
	CASE 2:	\
		SELECT (sensor_units)	\
		{ \
			CASE 1:		"6.1f";	\
			CASE 2:		"6.2f";	\
			CASE 4:		"6.f";	\
			CASE 5:		"6.1f";	\
			CASE 6:		"6.3f";	\
			CASE 7:		"6.3f";	\
			CASE 8:		"6.1f";	\
			CASE 10:		"6.3f";	\
			CASE 12:		"6.2f";	\
			CASE 14:		"6.3f";	\
			CASE 237:	"6.3f";	\
			CASE 240: 	"6.3f"; 	\
		}	\
	CASE 8:	\
		SELECT (sensor_units)	\
		{ \
			CASE 1:		"6.f";	\
			CASE 2:		"6.2f";	\
			CASE 4:	  	"6.f"; 	\
			CASE 5:		"6.f";	\
			CASE 6:		"6.2f";	\
			CASE 7:		"6.3f";	\
			CASE 8:		"6.1f"; 	\
			CASE 10:		"6.3f";	\
			CASE 12:		"6.1f";	\
			CASE 14:		"6.3f"; 	\
			CASE 237:	"6.3f";	\
			CASE 240: 	"6.2f";	\
		}\
	CASE 9:	\
		SELECT (sensor_units)	\
		{ \
			CASE 6:		"6.1f";	\
			CASE 7:		"6.1f";	\
			CASE 10:		"6.1f";	\
			CASE 14:		"6.1f"; 	\
			CASE 237:	"6.1f";	\
			CASE 240: 	"6.1f";	\
		}	\
	DEFAULT:	\
		SELECT (sensor_units)	\
		{ \
			CASE 1:		"6.f";	\
			CASE 2:		"6.1f";	\
			CASE 5:		"6.f";	\
			CASE 6:		"6.1f";	\
			CASE 7:		"6.3f";	\
			CASE 8:		"6.f"; 	\
			CASE 10:		"6.3f";	\
			CASE 12:		"6.1f";	\
			CASE 14:		"6.3f"; 	\
			CASE 237:	"6.3f";	\
			CASE 240: 	"6.2f";	\
		}	\
}



#define IDENTIFY_REPLY \
	response_code, device_status, 254, manufacturer_id, device_type, \
	request_preambles, universal_revision, transmitter_revision, \
	software_revision, hardware_revision <0xf8>, physical_signaling_code <0x07>, \
	device_flags, device_id





/*************************************/
/*				VAR - DEFINITION           */
/*************************************/
/*************************************************/
/*     DEFINITION UNIVERSAL COMMAND VARIABLES    */
/*************************************************/
VARIABLE response_code
{
	HELP [command_specific_response_code_help];
	CLASS USER_INTERFACE & DIAGNOSTIC;
	TYPE ENUMERATED
	{
		{ 0, 	[success] },
      { 1,  [undefined] },
      { 2,  [invalid_selection] },
      { 3,  [passed_parameter_too_large] },
      { 4,  [passed_parameter_too_small] },
      { 5,  [too_few_data_bytes_recieved] },
      { 6,  [xmtr_specific_command_error] },
      { 7,  [in_write_protect_mode] },
      { 8,  [xmtr_specific_command_error] },
      { 9,  [xmtr_specific_command_error] },
      { 10, [xmtr_specific_command_error] },
      { 11, [xmtr_specific_command_error] },
      { 12, [xmtr_specific_command_error] },
      { 13, [xmtr_specific_command_error] },
      { 14, [xmtr_specific_command_error] },
      { 15, [xmtr_specific_command_error] },
      { 16, [access_restricted] },
      { 32, [busy] },
      { 64, [command_not_implemented] }
   }
   HANDLING READ;
}



VARIABLE comm_status
{
	HELP [communications_error_summary_help];
	CLASS HART & DYNAMIC & DIAGNOSTIC;
  	TYPE BIT_ENUMERATED
	{
		{ 0x02, [buffer_overflow], HARDWARE & CORRECTABLE },
		{ 0x08, [longitudinal_parity_error], HARDWARE & CORRECTABLE },
		{ 0x10, [framing_error], HARDWARE & CORRECTABLE },
		{ 0x20, [overrun_error], HARDWARE & CORRECTABLE },
		{ 0x40, [vertical_parity_error], HARDWARE & CORRECTABLE }
	}
}



VARIABLE device_status
{
	LABEL [device_status];
	HELP [field_device_status_help];
	CLASS HART & DYNAMIC & DIAGNOSTIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED
	{
		{ 0x00, "OK"},
		{ 0x01, [PV_out_of_limits],				DV1 (AUTO & BAD) },
		{ 0x02, [Non_PV_out_of_limits], 			DV2 (AUTO & BAD) },
		{ 0x04, [PV_analog_output_saturated], 	AO1 (AUTO & BAD) },
		{ 0x08, [PV_analog_output_fixed], 		AO1 (MANUAL & GOOD) },
		{ 0x10, [more_status_available], 		MORE },
		{ 0x20, [cold_start],						MISC },
		{ 0x40, [configuration_changed], 		MISC & IGNORE_IN_HANDHELD },
		{ 0x80, [device_malfunction],				MORE}
	}
}


VARIABLE manufacturer_id
{
	HELP [manufacturer_id_code_help];
	LABEL [manufacturer_id];
	HANDLING READ;
	CLASS HART;
	TYPE ENUMERATED
	{
       /* KLAY */
        INITIAL_VALUE 117;
        DEFAULT_VALUE 117;

        { 1,   [Acromag] },
        { 2,   [Allen_Bradley] },
        { 3,   [Ametek] },
        { 4,   [Analog_Devices] },
        { 5,   [Bailey] },
        { 6,   [Beckman] },
        { 7,   [Bell_Microsensor] },
        { 8,   [Bourns] },
        { 9,   [Bristol_Babcock] },
        { 10,  [Brooks_Instrument] },
        { 11,  [Chessell] },
        { 12,  [Combustion_Engineering] },
        { 13,  [Daniel_Industries] },
        { 14,  [Delta] },
        { 15,  [Dieterich_Standard] },
        { 16,  [Dohrmann] },
        { 17,  [Endress_and_Hauser] },
        { 18,  [Fischer_and_Porter] },
        { 19,  [Fisher_Controls] },
        { 20,  [Foxboro] },
        { 21,  [Fuji] },
        { 22,  [Hartmann_and_Braun] },
        { 23,  [Honeywell] },
        { 24,  [ITT_Barton] },
        { 25,  [KayRay_Sensall] },
        { 26,  [Kent] },
        { 27,  [Leeds_and_Northrup] },
        { 28,  [Leslie] },
        { 29,  [M_System_Co] },
        { 30,  [Measurex] },
        { 31,  [Micro_Motion] },
        { 32,  [Moore_Industries] },
        { 33,  [Moore_Products] },
        { 34,  [Ohkura_Electric] },
        { 35,  [Paine] },
        { 36,  [Rochester_Instrument_Systems] },
        { 37,  [Ronan] },
        { 38,  [Rosemount] },
        { 39,  [Peek_Measurement] },
        { 40,  [Schlumberger] },
        { 41,  [Sensall] },
        { 42,  [Siemens] },
        { 43,  [Camille_Bauer] },
        { 44,  [Toshiba] },
        { 45,  [Transmation] },
        { 46,  [Rosemount_Analytical] },
        { 47,  [Valmet] },
        { 48,  [Valtek] },
        { 49,  [Varec] },
        { 50,  [Viatran] },
        { 51,  [Weed] },
        { 52,  [Westinghouse] },
        { 53,  [Xomox] },
        { 54,  [Yamatake] },
        { 55,  [Yokogawa] },
        { 56,  [Nuovo_Pignone] },
        { 57,  [Promac] },
        { 58,  [Exac_Corporation] },
        { 59,  [KDG_Mobrey] },
        { 60,  [Acrom_Control_System] },
        { 61,  [Princo] },
        { 62,  [Smar] },
        { 63,  [Eckardt] },
        { 64,  [Measurement_Technology] },
        { 65,  [Applied_System_Technologies] },
        { 66,  [Samson] },
        { 67,  [Sparling_Instruments] },
        { 68,  [Fireye] },
        { 69,  [Krohne] },
        { 70,  [Betz_Equipment] },
        { 71,  [Druck] },
        { 72,  [SOR] },
        { 73,  [Elcon_Instruments] },
        { 74,  [EMCO] },
        { 75,  [Termiflex] },
        { 76,  [VAF_Instruments] },
        { 77,  [Westlock_Controls] },
        { 78,  [Drexelbrook] },
        { 80,  [K_TEK] },
        { 81,  [Flowdata] },
        { 82,  [Draeger] },
        { 83,  [Raytek] },
        { 84,  [Meridian_Instruments] },
        { 85,  [BTG] },
        { 86,  [Magnetrol] },
        { 87,  [Neles_Jamesbury] },
        { 88,  [Milltronics] },
        { 89,  [HELIOS] },
        { 90,  [Anderson_Instrument_Company] },
        { 91,  [INOR] },
        { 92,  [ROBERTSHAW] },
        { 93,  [PEPPERL_FUCHS] },
        { 94,  [ACCUTECH] },
        { 95,  [Flow_Measurement] },
        { 96,  [KAMSTRUP] },
        { 97,  [Knick] },
        { 98,  [VEGA] },
        { 99,  [MTS_SYS_CORPS_SENSORS] },
        { 100, [Oval] },
        { 101, [Masoneilan_DRESSER] },
        { 102, [Besta] },
        { 103, [Ohmart] },
        { 104, "Harold Beck and Sons"           },
        { 105, "Rittmeyer Instrumentation"      },
        { 106, "Rossel Messtechnik"             },
        { 107, "WIKA"                           },
        { 108, "Bopp and Reuther Heinrichs"     },
        { 109, "pr eletronics"                  },
        { 110, "Jordan Controls"                },
        { 111, "Valcom"                         },
        { 112, "Us Electric Motors"             },
        { 113, "Apparatebau Hundsbach"          },
        { 117, "Klay Instruments" 					},
        { 250, [not_used] },
        { 251, [none] },
        { 252, [unknown] },
        { 253, [special] }
    }
}


VARIABLE device_type
{
	HELP [manufacturers_device_type_help];
	LABEL [device_type];
	HANDLING READ;
	CLASS HART;
	TYPE ENUMERATED
	{
		DEFAULT_VALUE 0xef;
      INITIAL_VALUE 0xef;

      SELECT (manufacturer_id){
      	CASE 117:
				{	0xef, "Klay 2000 Pressure/Level"}
		}
   }
}


VARIABLE request_preambles
{
	HELP [number_of_request_preambles_help];
	LABEL [number_of_request_preambles];
	HANDLING READ;
	CLASS HART;
	TYPE UNSIGNED_INTEGER
	{
		MIN_VALUE  2;
		MAX_VALUE  20;
	}
}


VARIABLE universal_revision
{
	HELP [universal_revision_help];
	LABEL [universal_revision];
	HANDLING READ;
	CLASS HART;

	TYPE UNSIGNED_INTEGER
	{
		MAX_VALUE  253;
	}
}


VARIABLE transmitter_revision
{
	HELP [field_device_revision_help];
	LABEL [transmitter_revision];
	HANDLING READ;
	CLASS HART;

	TYPE UNSIGNED_INTEGER
	{
		MAX_VALUE  253;
	}
}


VARIABLE software_revision
{
	HELP [field_device_software_revision_help];
	LABEL [software_revision];
	HANDLING READ;
	CLASS DEVICE;

	TYPE UNSIGNED_INTEGER
	{
		MAX_VALUE  253;
	}
}


VARIABLE hardware_revision
{
	HELP [hardware_revision_help];
	LABEL [hardware_revision];
	HANDLING READ;
	CLASS DEVICE;

	TYPE UNSIGNED_INTEGER;
}


VARIABLE physical_signaling_code
{
	HELP [physical_signalling_code_help];
	LABEL [physical_signalling_code];
	HANDLING READ;
	CLASS DEVICE;

	TYPE ENUMERATED
	{
		DEFAULT_VALUE 0;
      INITIAL_VALUE 0;

      { 0, [bell_202_current] },
      { 1, [bell_202_voltage] },
      { 2, [rs_485] },
      { 3, [rs_232], [rs_232_help] },
      { 6, [special] }
    }
}

VARIABLE device_flags
{
	HELP [field_device_flags_help];
	LABEL [device_flags];
	HANDLING READ;
	CLASS HART;

	TYPE BIT_ENUMERATED
   {
   	{ 0x01, [multi_sensor_fld_dev], [multi_sensor_fld_dev_help] },
      { 0x02, [EEPROM_Ctrl] },
      { 0x04, [protocol_bridge_device] }
   }
}


VARIABLE device_id
{
	HELP [field_device_identification_help];
	LABEL [device_identification];
	HANDLING READ;
	CLASS HART;

   TYPE UNSIGNED_INTEGER (3)
   {
       INITIAL_VALUE   0;
   }

}

VARIABLE polling_address
{
	HELP [polling_address_help];
	LABEL [polling_address];
	HANDLING WRITE;
	CLASS HART;

	TYPE UNSIGNED_INTEGER
	{
		DEFAULT_VALUE 0;
		MAX_VALUE 15;
	}
}



VARIABLE tag
{
	HELP [tag_help];
	LABEL [tag];
	CLASS DEVICE;
   HANDLING READ & WRITE;

	TYPE PACKED_ASCII (8){
   	DEFAULT_VALUE "Klay2000";
   }

}


VARIABLE message
{
	HELP [message_help];
	LABEL [message];
	CLASS DEVICE;
   HANDLING READ & WRITE;

	TYPE PACKED_ASCII (32)
   {
   	DEFAULT_VALUE " ";
      INITIAL_VALUE " ";
   }


}


VARIABLE descriptor
{
	HELP [discriptor_help];
	LABEL [descriptor];
	CLASS DEVICE;
   HANDLING READ & WRITE;

	TYPE PACKED_ASCII (16)
   {
   	DEFAULT_VALUE " ";
      INITIAL_VALUE " ";
   }
}


VARIABLE date
{
	HELP [date_help];
	LABEL [date];
	CLASS DEVICE;
   HANDLING READ & WRITE;

	TYPE DATE
   {
   	DEFAULT_VALUE "01.01.2006";
   }
}


VARIABLE write_protect
{
	HELP [write_protect_mode_help];
	LABEL [write_protect];
	CLASS DEVICE;
	HANDLING READ & WRITE;

	TYPE ENUMERATED
	{
		DEFAULT_VALUE 0;
      INITIAL_VALUE 0;

		/* Staat mooier op HC */
		{0, [not_write_protected]},
		{1, [write_protected]}
	}
}


VARIABLE private_label_distributor
{
	HELP [private_label_distributor_help];
	LABEL [private_label_distributor];
	HANDLING READ;
	CLASS DEVICE;

	TYPE ENUMERATED
	{
		DEFAULT_VALUE 117;

		{ 117,  "Klay Instruments" }
	}
}


VARIABLE final_assembly_number
{
	HELP [final_assembly_number_help];
	LABEL [final_assembly_number];
	CLASS DEVICE;
   HANDLING READ;

	TYPE UNSIGNED_INTEGER (3)
	{
		MAX_VALUE 16777215;
		EDIT_FORMAT "8u" ;
	}
}






/*************************************************/
/* DEFINITION COMMON PRACTICE COMMANDS VARIABLES */
/*************************************************/

/*	Definition of variable sensor_units */
VARIABLE sensor_units
{
	HELP [digital_units_help];
	CLASS CORRECTION;
	LABEL [pv_sensor_unit];
	HANDLING READ&WRITE;

	TYPE ENUMERATED
	{ /* Not all units are supported for the different klay transmitter types */
		KLAY_UNITS
	}
}


/*	Definition of sensorvalue (pressure) */
VARIABLE sensor_value
{
	HELP [digital_value_help];
	CLASS CORRECTION & DYNAMIC;
	LABEL [sensor_value];
	HANDLING READ;
	TYPE FLOAT
	{
		/* Redefine display formats for the different units */
		DISPLAY_FORMAT P_DISPLAY_PREC
	}
}


/*	Definition of variable sensor_upper_limit */
VARIABLE sensor_upper_limit
{
	HELP [upper_sensor_limit_help];
	CLASS CORRECTION;
	LABEL [klay_pv_usl];
	HANDLING READ;
	TYPE FLOAT
	{
		DISPLAY_FORMAT P_DISPLAY_PREC
	}
}


/*	Definition of variable sensor_lower_limit */
VARIABLE sensor_lower_limit
{
	HELP [lower_sensor_limit_help];
	CLASS CORRECTION;
	LABEL [klay_pv_lsl];
	HANDLING READ;
	TYPE FLOAT
	{
		DISPLAY_FORMAT P_DISPLAY_PREC
	}
}


/*	Definition of variable sensor_minimum_span */
VARIABLE sensor_minimum_span
{
	HELP [minimum_span_help];
	CLASS CORRECTION;
	LABEL [klay_pv_minimum_span];
	HANDLING READ;
	TYPE FLOAT
	{
		DISPLAY_FORMAT P_DISPLAY_PREC
	}
}



/* Variable is not in any command, but defined for method */
VARIABLE current_span
{
	HELP [minimum_span_help];
	CLASS LOCAL;
	LABEL [klay_current_span];

	TYPE FLOAT
	{
		DISPLAY_FORMAT P_DISPLAY_PREC
		EDIT_FORMAT P_EDIT_DISPLAY_PREC
	}
}



/*	Definition of sensor_damping_value */
VARIABLE sensor_damping_value
{
	HELP [seconds_damping_value_help];
	LABEL [pv_damping_value];
	CLASS CORRECTION;
	HANDLING READ & WRITE;
	CONSTANT_UNIT [sec];

	TYPE FLOAT
	{
   	DEFAULT_VALUE 0;
      INITIAL_VALUE 0;

		DISPLAY_FORMAT ".1f";
		EDIT_FORMAT "4.1f";
		MIN_VALUE  0;
		MAX_VALUE 25;
	}
}



/*	Definition of the analog value */
VARIABLE analog_value
{
	HELP [analog_value_help];
	CLASS CONTAINED & DYNAMIC;
	LABEL [klay_analog_value];

	HANDLING READ & WRITE;
	CONSTANT_UNIT [mA];

	TYPE FLOAT
	{
		DEFAULT_VALUE 4.0;
      INITIAL_VALUE 0;

		DISPLAY_FORMAT ".2f";
		EDIT_FORMAT "6.3f";

      MIN_VALUE 3.9;
      MAX_VALUE 20.8;
	}
}


/*	Definition of the analog_alarm_code */
VARIABLE analog_alarm_code
{
	HELP [alarm_code_help];
	CLASS INPUT;
	LABEL [alarm_select];
	HANDLING READ;
	TYPE ENUMERATED
	{
		{	0,		[high],							[high_help]	},
      {	1,		[low],							[low_help]	},
      {	239,	[hold_last_output_value],	[hold_last_output_value_help]	},
		{ 	250, 	[not_used] },
      { 	251, 	[none] },
      { 	252, 	[unknown] },
      { 	253, 	[special] }
	}
}


/*	Definiton of variable input_percent_of_range */
VARIABLE input_percent_range
{
	HELP [percent_of_range_help];
	CLASS INPUT & DYNAMIC;
	LABEL [klay_percent_range];
	CONSTANT_UNIT [Percent];
	HANDLING READ;
	TYPE FLOAT
	{
		DISPLAY_FORMAT "3.1f";
	}
}






/*	Define variable of response_preamples */
VARIABLE response_preambles
{
	HELP [number_of_response_preambles_help];
	LABEL [number_of_response_preambles];
	CLASS HART;
	HANDLING WRITE;

	TYPE UNSIGNED_INTEGER
   {
   	DEFAULT_VALUE 5;
      INITIAL_VALUE 5;
   }
}


/*	Define variabel input_upper_value */
VARIABLE input_upper_value
{
	HELP [upper_range_value_help];
	LABEL [pv_urv];
	CLASS INPUT;
	HANDLING READ & WRITE;

	TYPE FLOAT
	{
		DISPLAY_FORMAT P_DISPLAY_PREC
		EDIT_FORMAT P_EDIT_DISPLAY_PREC
	}
}


/* Define variabel input_upper_value */
VARIABLE input_lower_value
{
	HELP [lower_range_value_help];
	LABEL [pv_lrv];
	CLASS INPUT;
	HANDLING READ & WRITE;

	TYPE FLOAT
	{
		DISPLAY_FORMAT P_DISPLAY_PREC
		EDIT_FORMAT P_EDIT_DISPLAY_PREC
	}
}



/*	Define variable sensor_serial_number */
VARIABLE sensor_serial_number
{
	HELP [sensor_serial_number_help];
	CLASS DEVICE;
	LABEL [pv_sensor_serial_number];
	HANDLING READ&WRITE;
	TYPE UNSIGNED_INTEGER (3)
	{
		EDIT_FORMAT  "7d";
		DISPLAY_FORMAT  "7d";
	}
}


/*	Defining temperature_unit */
VARIABLE temperature_units
{
	CLASS CORRECTION;
	LABEL [klay_temp_unit];
	HANDLING READ & WRITE;
	TYPE ENUMERATED
	{
      DEFAULT_VALUE 32;

      { 	32, 	[degC] 		},
		{ 	33, 	[degF] 	}

	}
}


/*	Defining procestemperature */
VARIABLE proces_temp_value
{
	HELP [klay_proces_temp_value_help];
	CLASS CORRECTION & DYNAMIC;
	LABEL [klay_proces_temp_value];
	HANDLING READ;

	TYPE FLOAT
	{
		DISPLAY_FORMAT "5.1f";
	}
}



/*	Defining housing/ambient temperature */
VARIABLE housing_temp_value
{
	HELP [klay_housing_temp_help];
	CLASS CORRECTION & DYNAMIC;
	LABEL [klay_housing_temp];
	HANDLING READ;

	TYPE FLOAT
	{
		DISPLAY_FORMAT "5.1f";
	}
}

VARIABLE hecto_value
{
	CLASS CORRECTION & DYNAMIC;
	LABEL "vOLUME";
	CONSTANT_UNIT [hecto_liter];
   HANDLING READ;

	TYPE FLOAT
	{
		DEFAULT_VALUE 0.;
		DISPLAY_FORMAT ".2f";
	}
}

/* Variable is not in any command, but defined for method */
VARIABLE heco_value
{
	CLASS CORRECTION & DYNAMIC;
	LABEL "vOLUME";
	CONSTANT_UNIT [hecto_liter];
   HANDLING READ;

	TYPE FLOAT
	{
		DEFAULT_VALUE 0.;
		DISPLAY_FORMAT ".2f";
	}
}

/*	Defining temperature_unit */
VARIABLE lin_units
{
	CLASS CORRECTION;
	LABEL [volume_unit];
	HANDLING READ;

	TYPE ENUMERATED
	{
      DEFAULT_VALUE 236;

      { 	236, 	[hecto_liter] 		}

	}
}


VARIABLE local_write_protect
{
	HELP [write_protect_mode_help];
	LABEL[klay_local_wp];

	HANDLING WRITE & READ;
	CLASS DEVICE;
	TYPE ENUMERATED
	{
		DEFAULT_VALUE 0;

		{0, [not_write_protected]},
		{1, [write_protected]}
	}
}


VARIABLE set_cancel_mounting_position
{
	CLASS CORRECTION;
	LABEL [klay_cancel_mounting_pos];
	HELP  "Not Defined";
	HANDLING WRITE;
	TYPE ENUMERATED
	{
		DEFAULT_VALUE 0;
      INITIAL_VALUE 0;

		{0, [klay_cancel_mounting_pos_reset]},
		{1, [klay_cancel_mounting_pos_set]}

	}
}


/*	Defining variable used for display readout */
VARIABLE display_readout
{
	CLASS DEVICE;
	LABEL [klay_display_readout];
	HELP [klay_display_readout_help];
	HANDLING READ & WRITE;
	TYPE ENUMERATED
	{
		{0, "4-20 mA""|de|4-20 mA","4-20 mA readout on display""|de|4-20 mA Anzeige am Display"},
		{1, "Units""|de|Einheiten","Digital units readout on display""|de|Druck Einheiten Anzeige am Display"},
		{2, "Percent""|de|Prozent","Percent of range readout on display""|de|Prozent Mespanne Anzeige am Display"},
		{3, "Proces Temperature""|de|Prozetemperatur","Proces temperature readout on display""|de|Prozetemperatur Anzeige am Display"},
		{4, "Hectoliter""|de|Hectoliter","Hectoliter readout on display, only when tanklineairisation is active""|de|Hectoliter Anzeige am Display"},
		{5, "Cubic Meter""|de|Kubikmeter","Cubic meter readout on display, only when tanklineairisation is active""|de|Kubikmeter Anzeige am Display"}
	}
}



/*	Defining variable for reverse output*/
VARIABLE reverse_output
{
	CLASS DEVICE;
	LABEL [klay_reverse_output];
	HELP [klay_reverse_output_help];
	HANDLING READ & WRITE;
	TYPE ENUMERATED
	{
		{0, "4-20 mA""|de|4-20 mA","4-20 mA output""|de|4-20 mA Ausgang"},
		{1, "20-4 mA""|de|20-4 mA","20-4 mA output""|de|4-20 mA Ausgang"}
	}
}



/*	Defining variable used with lineairisation, height of tank */
VARIABLE h1
{
	CLASS CORRECTION;
	LABEL H1LABEL
	HELP "Height of the tank, for horizontal tank enter diameter""|de|Hhe vom Tank, beim zylindrischer Tank Durchmeer einfhren";
	HANDLING READ & WRITE;
	CONSTANT_UNIT [meter];

	TYPE FLOAT
	{
		DISPLAY_FORMAT "6.3f";
		EDIT_FORMAT "7.3f";
	}
}


/*	Defining variable used with lineairisation, length of tank */
VARIABLE h2_d
{
	CLASS CORRECTION;
	LABEL H2DLABEL //"Lenght of tank""|de|Lnge vom Tank";
	HELP "Lenght of the tank, for vertikal tank with cone enter diameter""|de|Lnge vom Tank, beim Tank mit konischer Boden Durchmeer einfhren";
	HANDLING READ & WRITE;
	CONSTANT_UNIT [meter];
	TYPE FLOAT
	{
		DISPLAY_FORMAT "6.3f";
		EDIT_FORMAT "7.3f";
	}
}


/*	Defining variable used with lineairisation, diameter of tank */
VARIABLE h2_l
{
	CLASS CORRECTION;
	LABEL H2LLABEL //"Height of cone""|de|Hhe des Konisches Tankteiles";
	HELP "Height of the cone, if there's no cone enter 0""|de|Hhe des Konisches Tankteiles, wenn es kein gibt null eingeben";
	HANDLING READ & WRITE;
	CONSTANT_UNIT [meter];
	TYPE FLOAT
	{
		DISPLAY_FORMAT "6.3f";
		EDIT_FORMAT "7.3f";
	}
}


/*	Defining variable used with lineairisation, mountingheight of device */
VARIABLE h3
{
	CLASS CORRECTION;
	LABEL H3LABEL //"Height of device""|de|Hhe des transmitters";
	HELP "Height of the device, this is the height of the bottom of the tank to de device""|de|Hhe des transmitters,Hhe vom Boden bis transmitter";
	HANDLING READ & WRITE;
	CONSTANT_UNIT [meter];
	TYPE FLOAT
	{
		DISPLAY_FORMAT "6.3f";
		EDIT_FORMAT "7.3f";
	}
}


VARIABLE h4
{
	CLASS CORRECTION;
	LABEL "Height of straight part""|de|Hhe des rechten Teil";
	HELP "";
	HANDLING READ & WRITE;
	CONSTANT_UNIT [meter];
	TYPE FLOAT
	{
		DISPLAY_FORMAT "6.3f";
		EDIT_FORMAT "7.3f";
	}
}



/*	Defining variable for maximum span */
VARIABLE maximum_span
{
	CLASS CORRECTION;
	LABEL [klay_maximum_span];
	HANDLING READ;
	TYPE FLOAT
	{
		DISPLAY_FORMAT P_DISPLAY_PREC
	}
}



/*	Defining variable used with lineairisation, density factor */
VARIABLE density_factor
{
	CLASS CORRECTION;
	LABEL [klay_density_factor];
	HANDLING READ & WRITE;
	CONSTANT_UNIT [g_CuCm];

	TYPE FLOAT
	{
		MIN_VALUE 0.5;
		MAX_VALUE 2.0;
		DISPLAY_FORMAT "6.3f";
		EDIT_FORMAT "7.3f";
	}
}


/*	Defining variable for diapragmmaterial */
VARIABLE diaphragm_material
{
	CLASS DEVICE;
	LABEL [remote_seal_isolator_mat];
	HANDLING READ;
	TYPE ENUMERATED
	{
			 { 2,   [stainless_steel_316], [stainless_steel_316_help] },
			 { 3,   [hastelloy_c],	     [hastelloy_c_help] },
			 { 5,   [tantalum],	     [tantalum_help] },
			 { 6,   [titanium],	     [titanium_help] },
			 { 250, [not_used] },
			 { 251, [none] },
			 { 252, [unknown] },
			 { 253, [special] }
	}
}



/*	Defining variable for O-ring material */
VARIABLE o_ring_material
{
	CLASS DEVICE;
	LABEL [o_ring_material];
	HANDLING READ;
	TYPE ENUMERATED
	{
			 { 10,  [ptfe],		     [ptfe_teflon_help] },
			 { 11,  [vito],		     [viton_help] },
			 { 13,  [ethyl_prop],	     [ethyl_prop_help] },
			 { 22,  [kalrez], 	     [kalrez_help] },
			 { 250, [not_used] },
			 { 251, [none] },
			 { 252, [unknown] },
			 { 253, [special] }
	}
}


/*	Define klay_typecode, for the different range the klay transmitter can have */
VARIABLE klay_typecode
{
	CLASS DEVICE;
	LABEL [klay_sensor_type];
	HANDLING READ;
	TYPE ENUMERATED
	{
		{1, "2000 Range 1"},
		{2, "2000 Range 2"},
		{3, "2000 Range 3"},
		{4, "2000 (SAN) Range 4"},
		{6, "CER 2000 Range 4"},
		{8, "2000 Special"},
		{9, "CER 2000 Range 5"}
	}
}



/**************************************/
/*         COMMAND DEFINITION         */
/**************************************/

/* Definition of universal cmd's */
COMMAND read_unique_identifier
{
	NUMBER 0;

	OPERATION READ;

	TRANSACTION
	{
		REQUEST
		{}

		REPLY
		{
			IDENTIFY_REPLY
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,		[no_command_specific_errors];
		6,		MISC_ERROR,	[xmtr_specific_command_error];
		16,	MODE_ERROR,	[access_restricted];
	}
}



COMMAND read_pv
{
	NUMBER 1;

	OPERATION READ;

	TRANSACTION
	{
		REQUEST
		{}

		REPLY
		{
			response_code, device_status, sensor_units, sensor_value
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,			[no_command_specific_errors];
		6,		MISC_ERROR,		[xmtr_specific_command_error];
		8,		MISC_WARNING,	[update_failure];
		16,	MODE_ERROR,		[access_restricted];
	}
}



COMMAND read_pv_current_and_percent_range
{
	NUMBER 2;

	OPERATION READ;

	TRANSACTION
	{
		REQUEST
		{}

		REPLY
		{
			response_code, device_status, analog_value, input_percent_range
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,				[no_command_specific_errors];
		6,		MISC_ERROR,			[xmtr_specific_command_error];
		8,		MISC_WARNING,		[update_failure];
		16,	MODE_ERROR,			[access_restricted];
	}
}


COMMAND read_dynamic_variables_and_pv_current
{
	//Commando is aangepast per revisie 8. Uitbreiding met twee variabelen
	NUMBER 3;

	OPERATION READ;

	TRANSACTION
	{
		REQUEST
		{}

		REPLY
		{
			response_code, device_status,
			analog_value,
			sensor_units, sensor_value,    				/* Druk */
			temperature_units, proces_temp_value,    	/* Proces temp */
         /* uitbreiding */
			temperature_units, housing_temp_value,	 	/* Omgevings temp */
			lin_units, hecto_value	 						/* Hectoliter */
		}
	}

	RESPONSE_CODES
	{
   	0,		SUCCESS,			[no_command_specific_errors];
		6,		MISC_ERROR,		[xmtr_specific_command_error];
		8,		MISC_WARNING,	[update_failure];
		16,	MODE_ERROR,		[access_restricted];
	}
}



COMMAND write_polling_address
{
	NUMBER 6;

	OPERATION WRITE;

	TRANSACTION
	{
		REQUEST
		{
			polling_address
		}

		REPLY
		{
			response_code, device_status, polling_address
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,				[no_command_specific_errors];
		2,		DATA_ENTRY_ERROR,	[invalid_selection];
		5,		MISC_ERROR,			[too_few_data_bytes_recieved];
		6,		MISC_ERROR,			[xmtr_specific_command_error];
		7,		MODE_ERROR,			[in_write_protect_mode];
		16,	MODE_ERROR,			[access_restricted];
	}
}


COMMAND read_unique_identifier_with_tag
{
	NUMBER 11;

	OPERATION COMMAND;

	TRANSACTION
	{
		REQUEST
		{
			tag
		}

		REPLY
		{
			IDENTIFY_REPLY
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,			[no_command_specific_errors];
		5, 	MISC_ERROR, 	[too_few_data_bytes_recieved];
		6,		MISC_ERROR,		[xmtr_specific_command_error];
		16,	MODE_ERROR,		[access_restricted];
	}
}


COMMAND read_message
{
	NUMBER 12;

	OPERATION READ;

	TRANSACTION
	{
		REQUEST
		{}

		REPLY
		{
			response_code, device_status, message
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,		[no_command_specific_errors];
		6,		MISC_ERROR,	[xmtr_specific_command_error];
		16,	MODE_ERROR,	[access_restricted];
	}
}



COMMAND read_tag_descriptor_date
{
	NUMBER 13;

	OPERATION READ;

	TRANSACTION
	{
		REQUEST
		{}

		REPLY
		{
			response_code, device_status, tag, descriptor, date
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,		[no_command_specific_errors];
		6,		MISC_ERROR, [xmtr_specific_command_error];
		16,	MODE_ERROR, [access_restricted];
	}
}


COMMAND read_pv_sensor_info
{
	NUMBER 14;

	OPERATION READ;

	TRANSACTION
	{
		REQUEST
		{}

		REPLY
		{
			response_code, device_status,
			sensor_serial_number, sensor_units,
			sensor_upper_limit, sensor_lower_limit,
			sensor_minimum_span
		}
	}

	RESPONSE_CODES
	{
		0, 	SUCCESS,		[no_command_specific_errors];
		6,		MISC_ERROR, [xmtr_specific_command_error];
		16,	MODE_ERROR, [access_restricted];
	}
}


COMMAND read_pv_output_info
{
	NUMBER 15;

	OPERATION READ;

	TRANSACTION
	{
		REQUEST
		{}

		REPLY
		{
			response_code, device_status,
			analog_alarm_code, input_transfer_function,
			sensor_units, input_upper_value, input_lower_value,
			sensor_damping_value, write_protect, private_label_distributor
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,		[no_command_specific_errors];
		6,		MISC_ERROR, [xmtr_specific_command_error];
		16,	MODE_ERROR, [access_restricted];
	}
}



COMMAND read_final_assembly_number
{
	NUMBER 16;

	OPERATION READ;

	TRANSACTION
	{
		REQUEST
		{}

		REPLY
		{
			response_code, device_status, final_assembly_number
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,		[no_command_specific_errors];
		6,		MISC_ERROR, [xmtr_specific_command_error];
		16,	MODE_ERROR, [access_restricted];
	}
}


COMMAND write_message
{
	NUMBER 17;

	OPERATION WRITE;

	TRANSACTION
	{
		REQUEST
		{
			message
		}

		REPLY
		{
			response_code, device_status, message
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,		[no_command_specific_errors];
		5,		MISC_ERROR, [too_few_data_bytes_recieved];
		6,		MISC_ERROR, [xmtr_specific_command_error];
		7,		MODE_ERROR, [in_write_protect_mode];
		16,	MODE_ERROR, [access_restricted];
	}
}


COMMAND write_tag_descriptor_date
{
	NUMBER 18;

	OPERATION WRITE;

	TRANSACTION
	{
		REQUEST
		{
			tag, descriptor, date
		}

		REPLY
		{
			response_code, device_status, tag, descriptor, date
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,		[no_command_specific_errors];
		5,		MISC_ERROR, [too_few_data_bytes_recieved];
		6,		MISC_ERROR, [xmtr_specific_command_error];
		7,		MODE_ERROR, [in_write_protect_mode];
		16,	MODE_ERROR, [access_restricted];
	}
}


COMMAND write_final_assembly_number
{
	NUMBER 19;

	OPERATION WRITE;

	TRANSACTION
	{
		REQUEST
		{
			final_assembly_number
		}

		REPLY
		{
			response_code, device_status, final_assembly_number
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,		[no_command_specific_errors];
		5,		MISC_ERROR, [too_few_data_bytes_recieved];
		6,		MISC_ERROR, [xmtr_specific_command_error];
		7,		MODE_ERROR, [in_write_protect_mode];
		16,	MODE_ERROR, [access_restricted];
	}
}





/* COMMON PRACTICE COMMANDS */

/*
	Defining the common practice commands
*/

COMMAND write_pv_damping_value
{
	NUMBER 34;

	OPERATION WRITE;

	TRANSACTION
	{
		REQUEST
		{
			sensor_damping_value
		}

		REPLY
		{
			response_code, device_status, sensor_damping_value
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS, 				[no_command_specific_errors];
		3,		DATA_ENTRY_ERROR,		[passed_parameter_too_large];
		4,		DATA_ENTRY_ERROR,		[passed_parameter_too_small];
		5,		MISC_ERROR,				[too_few_data_bytes_recieved];
		6,		MISC_ERROR,				[xmtr_specific_command_error];
		7,		MODE_ERROR,				[in_write_protect_mode];
		8,		DATA_ENTRY_WARNING,	[set_to_nearest_possible_value];
		16,	MODE_ERROR,				[access_restricted];
	}
}

COMMAND write_pv_range_values
{
	NUMBER 35;

	OPERATION WRITE;

	TRANSACTION
	{
		REQUEST
		{
			sensor_units(INFO), input_upper_value, input_lower_value
		}

		REPLY
		{
			response_code, device_status,
			sensor_units(INFO), input_upper_value, input_lower_value
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,						[no_command_specific_errors];
		2,		DATA_ENTRY_ERROR,			[invalid_selection];
		5,		MISC_ERROR,					[too_few_data_bytes_recieved];
		6,		MISC_ERROR,					[xmtr_specific_command_error];
		7,		MODE_ERROR,					[in_write_protect_mode];
		9,		DATA_ENTRY_ERROR,			[lower_range_value_too_high];
		10,	DATA_ENTRY_ERROR,			[lower_range_value_too_low];
		11,	DATA_ENTRY_ERROR,			[upper_range_value_too_high];
		12,	DATA_ENTRY_ERROR,			[upper_range_value_too_low];
		13,	DATA_ENTRY_ERROR,			[URV_and_LRV_out_of_limits];
		14,	DATA_ENTRY_WARNING,		[span_too_small];
		16,	MODE_ERROR,					[access_restricted];
	}
}


COMMAND set_pv_upper_range_value
{
	NUMBER 36;

	OPERATION COMMAND;

	TRANSACTION
	{
		REQUEST
		{}

		REPLY
		{
			response_code, device_status
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,						[no_command_specific_errors];
		6,		MISC_ERROR,					[xmtr_specific_command_error];
		7,		MODE_ERROR,					[in_write_protect_mode];
		9,		PROCESS_ERROR,				[applied_process_too_high];
		10,	PROCESS_ERROR,				[applied_process_too_low];
		14,	DATA_ENTRY_WARNING,		[span_too_small];
		16,	MODE_ERROR,					[access_restricted];
	}
}


COMMAND set_pv_lower_range_value
{
	NUMBER 37;

	OPERATION COMMAND;

	TRANSACTION
	{
		REQUEST
		{}

		REPLY
		{
			response_code, device_status
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,						[no_command_specific_errors];
		6,		MISC_ERROR,					[xmtr_specific_command_error];
		7,		MODE_ERROR,					[in_write_protect_mode];
		9,		PROCESS_ERROR,				[applied_process_too_high];
		10,	PROCESS_ERROR,				[applied_process_too_low];
		14,	DATA_ENTRY_WARNING,		[new_LRV_pushed_URV_over_USL];
		16,	MODE_ERROR,					[access_restricted];
	}
}
/******************/

VARIABLE config_change_counter
{
    LABEL "configuration_change_counter";
    HELP "configuration_change_counter_help";
    CLASS DEVICE & DYNAMIC;
    HANDLING READ;
    TYPE UNSIGNED_INTEGER (2);
}


COMMAND reset_configuration_change_flag
{
    NUMBER 38;
    OPERATION COMMAND;
    TRANSACTION
    {
        REQUEST 
		{}
		
        REPLY
        {
            response_code, device_status, config_change_counter
        }
    }
    RESPONSE_CODES
    {
        0,  SUCCESS,            [no_command_specific_errors];
        5,  DATA_ENTRY_ERROR,   [too_few_data_bytes_recieved];
        6,  MISC_ERROR,         [xmtr_specific_command_error];
        7,  MODE_ERROR,         [in_write_protect_mode];
        9,  MISC_ERROR,         "Configuration Change Counter Mismatch";
        16, MODE_ERROR,         [access_restricted];
    }
}

/******************/

COMMAND enter_exit_fixed_pv_current_mode
{
	NUMBER 40;

	OPERATION COMMAND;

	TRANSACTION
	{
		REQUEST
		{
			analog_value
		}
		REPLY
		{
			response_code, device_status, analog_value
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,					[no_command_specific_errors];
		3,		DATA_ENTRY_ERROR,		[passed_parameter_too_large];
		4,		DATA_ENTRY_ERROR,		[passed_parameter_too_small];
		5,		MISC_ERROR,				[too_few_data_bytes_recieved];
		6,		MISC_ERROR,				[xmtr_specific_command_error];
		7,		MODE_ERROR,				[in_write_protect_mode];
		11,	MODE_ERROR,				[in_multidrop_mode];
		16,	MODE_ERROR,				[access_restricted];
	}
}


COMMAND perform_master_reset
{
	NUMBER 42;

   OPERATION COMMAND;

   TRANSACTION
   {
   	REQUEST
      {

      }
      REPLY
      {

      }
   }

   RESPONSE_CODES
   {
		0,		SUCCESS,				[no_command_specific_errors];
		6,		MISC_ERROR,			[xmtr_specific_command_error];
		7,		MODE_ERROR,			[in_write_protect_mode];
		16,	MODE_ERROR,			[access_restricted];
	}
}



COMMAND write_pv_units
{
	NUMBER 44;

	OPERATION WRITE;

	TRANSACTION
	{
		REQUEST
		{
			sensor_units
		}

		REPLY
		{
			response_code, device_status, sensor_units
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,					[no_command_specific_errors];
		2,		DATA_ENTRY_ERROR,		[invalid_selection];
		5,		MISC_ERROR,				[too_few_data_bytes_recieved];
		6,		MISC_ERROR,				[xmtr_specific_command_error];
		7,		MODE_ERROR,				[in_write_protect_mode];
		16,	MODE_ERROR,				[access_restricted];
	}
}


COMMAND trim_pv_current_dac_zero
{
	NUMBER 45;

	OPERATION COMMAND;

	TRANSACTION
	{
		REQUEST
		{
			analog_value
		}

		REPLY
		{
			response_code, device_status, analog_value
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,				[no_command_specific_errors];
		3,		DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		4,		DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		5,		MISC_ERROR,			[too_few_data_bytes_recieved];
		6,		MISC_ERROR,			[xmtr_specific_command_error];
		7,		MODE_ERROR,			[in_write_protect_mode];
		9,		MODE_ERROR,			[not_in_proper_current_mode];
		11,	MODE_ERROR,			[in_multidrop_mode];
		16,	MODE_ERROR,			[access_restricted];
	}
}


COMMAND trim_pv_current_dac_gain
{
	NUMBER 46;

	OPERATION COMMAND;

	TRANSACTION
	{
		REQUEST
		{
			analog_value
		}

		REPLY
		{
			response_code, device_status, analog_value
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,				[no_command_specific_errors];
		3,		DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		4,		DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		5,		MISC_ERROR,			[too_few_data_bytes_recieved];
		6,		MISC_ERROR,			[xmtr_specific_command_error];
		7,		MODE_ERROR,			[in_write_protect_mode];
		9,		MODE_ERROR,			[not_in_proper_current_mode];
		11,	MODE_ERROR,			[in_multidrop_mode];
		16,	MODE_ERROR,			[access_restricted];
	}
}


COMMAND write_number_of_response_preambles
{
	NUMBER 59;

	OPERATION WRITE;

	TRANSACTION
	{
		REQUEST
		{
			response_preambles
		}

		REPLY
		{
			response_code, device_status, response_preambles
		}
	}

	RESPONSE_CODES
	{
		0,		SUCCESS,					[no_command_specific_errors];
		3,		DATA_ENTRY_ERROR,		[passed_parameter_too_large];
		4,		DATA_ENTRY_ERROR,		[passed_parameter_too_small];
		5,		MISC_ERROR,				[too_few_data_bytes_recieved];
		6,		MISC_ERROR,				[xmtr_specific_command_error];
		7,		MODE_ERROR,				[in_write_protect_mode];
		16,	MODE_ERROR,				[access_restricted];
	}
}




/* DEFINING TRANSMITTER SPECIFIC COMMANDS */

/*
	Definition of our own commands and variables
*/

COMMAND read_static_transmitter_data
{
	NUMBER	128;

	OPERATION	READ;

	TRANSACTION
	{
		REQUEST
		{}

		REPLY
		{
			response_code, device_status,
			diaphragm_material, o_ring_material, klay_typecode,
			device_type, sensor_upper_limit, sensor_lower_limit,
			sensor_minimum_span, maximum_span
		}
	}

	RESPONSE_CODES
	{
		0,	SUCCESS,			[no_command_specific_errors];
	}
}


COMMAND read_special_transmitter_data
{
	NUMBER 129;

	OPERATION READ;

	TRANSACTION
	{
		REQUEST
		{}

		REPLY
		{
			response_code, device_status,
			display_readout, reverse_output, input_transfer_function,
			h1, h2_d, h2_l, h3
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,			[no_command_specific_errors];
	}
}


COMMAND read_density_factor
{
	NUMBER 130;

	OPERATION READ;

	TRANSACTION
	{
		REQUEST
		{}

		REPLY
		{
			response_code, device_status,
			density_factor
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,			[no_command_specific_errors];
	}
}


COMMAND read_levelpercent_and_h4
{
	NUMBER 131;

	OPERATION READ;

	TRANSACTION
	{
		REQUEST
		{}

		REPLY
		{
			response_code, device_status,
			levelpercent, h4
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,			[no_command_specific_errors];
	}
}


COMMAND change_display_readout
{
	NUMBER 140;

	OPERATION WRITE;

	TRANSACTION
	{
		REQUEST
		{
			display_readout
		}

		REPLY
		{
			response_code, device_status,
			display_readout
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,				[no_command_specific_errors];
		2,	DATA_ENTRY_ERROR,	[invalid_selection];
		5,	MISC_ERROR,			[too_few_data_bytes_recieved];
		7,	MODE_ERROR,			[in_write_protect_mode];
	}
}


COMMAND set_inbouw_mm
{
	NUMBER 150;

	OPERATION WRITE;

	TRANSACTION
	{
		REQUEST
			{
				set_cancel_mounting_position
			}

			REPLY
			{
				response_code, device_status,
				set_cancel_mounting_position
			}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,				[no_command_specific_errors];
		2,	DATA_ENTRY_ERROR,	[invalid_selection];
		5,	MISC_ERROR,			[too_few_data_bytes_recieved];
		7,	MODE_ERROR,			[in_write_protect_mode];
	}
}


COMMAND write_tanklineairisation
{
	NUMBER 151;

	OPERATION WRITE;

	TRANSACTION
	{
		REQUEST
		{
			input_transfer_function,
			h1, h2_d, h2_l, h3
		}

		REPLY
		{
			response_code, device_status,
			input_transfer_function,
			h1, h2_d, h2_l, h3
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,				[no_command_specific_errors];
		2,	DATA_ENTRY_ERROR,	[invalid_selection];
		5,	MISC_ERROR,			[too_few_data_bytes_recieved];
		7,	MODE_ERROR,			[in_write_protect_mode];
	}
}



COMMAND reverse_output_mode
{
	NUMBER 152;

	OPERATION WRITE;

	TRANSACTION
	{
		REQUEST
		{
			reverse_output
		}

		REPLY
		{
			response_code, device_status,
			reverse_output
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,				[no_command_specific_errors];
		2,	DATA_ENTRY_ERROR,	[invalid_selection];
		5,	MISC_ERROR,			[too_few_data_bytes_recieved];
		7,	MODE_ERROR,			[in_write_protect_mode];
		11, MODE_ERROR,		[in_multidrop_mode];
	}
}


COMMAND write_density_factor
{
	NUMBER 153;

	OPERATION WRITE;

	TRANSACTION
	{
		REQUEST
		{
			density_factor
		}

		REPLY
		{
			response_code, device_status,
			density_factor
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,				[no_command_specific_errors];
		5,	MISC_ERROR,			[too_few_data_bytes_recieved];
		7,	MODE_ERROR,			[in_write_protect_mode];
	}
}


COMMAND write_levelpercent_and_h4
{
	NUMBER 154;

	OPERATION WRITE;

	TRANSACTION
	{
		REQUEST
		{
			levelpercent, h4
		}

		REPLY
		{
			response_code, device_status,
			levelpercent, h4
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,					[no_command_specific_errors];
		2,	DATA_ENTRY_ERROR,		[invalid_selection];
		5,	MISC_ERROR,				[too_few_data_bytes_recieved];
		7,	MODE_ERROR,				[in_write_protect_mode];
	}
}



COMMAND write_temp_units
{
	NUMBER 155;

	OPERATION WRITE;

	TRANSACTION
	{
		REQUEST
		{
			temperature_units
		}

		REPLY
		{
			response_code, device_status,
			temperature_units
		}
	}

	RESPONSE_CODES
	{
		0,	SUCCESS,				[no_command_specific_errors];
		2,	DATA_ENTRY_ERROR,	[invalid_selection];
		5,	MISC_ERROR,			[too_few_data_bytes_recieved];
		7,	MODE_ERROR,			[in_write_protect_mode];
	}
}


COMMAND read_write_protection
{
	NUMBER 160;

	OPERATION READ;

	TRANSACTION
	{
		REQUEST
		{
			device_type
		}

		REPLY
		{
			response_code, device_status,
			device_type, write_protect, local_write_protect
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,				[no_command_specific_errors];
		2,	DATA_ENTRY_ERROR,	[invalid_selection];
		5,	MISC_ERROR,			[too_few_data_bytes_recieved];
	}
}


COMMAND write_write_protection
{
	NUMBER 161;

	OPERATION WRITE;

	TRANSACTION
	{
		REQUEST
		{
			device_type, write_protect, local_write_protect
		}

		REPLY
		{
			response_code, device_status,
			device_type, write_protect, local_write_protect
		}
	}
	RESPONSE_CODES
	{
		0,	SUCCESS,				[no_command_specific_errors];
		2,	DATA_ENTRY_ERROR,	[invalid_selection];
		5,	MISC_ERROR,			[too_few_data_bytes_recieved];
	}
}

/*
	Configuration of the dynamic variables
*/
ARRAY OF COLLECTION dynamic_variables
{
	ELEMENTS
	{
		PRIMARY,   pv, [klay_pv_dynamic_var];  /* Pressure values */
		SECONDARY, sv, [klay_sv_dynamic_var];  /* Proces temperature values */
		TERTIARY,  tv, [klay_tv_dynamic_var];	/* Ambient temperature values */
		FOURTH,	  qv, [klay_qv_dynamic_var];	/* Hectoliter value (if configured)*/
	}
}


COLLECTION OF VARIABLE PV
{
	LABEL [pv];
	HELP [primary_variable_help];
	MEMBERS
	{
/* Sensor Correction Information */
		DIGITAL_UNITS,			sensor_units,			[units],				[digital_units_help];
		DIGITAL_VALUE,			sensor_value,			[blank],				[blank];
		SENSOR_UNITS,			sensor_units,			[sensor_unit],		[digital_units_help];
		UPPER_SENSOR_LIMIT,	sensor_upper_limit,	[usl],				[upper_sensor_limit_help];
		LOWER_SENSOR_LIMIT,	sensor_lower_limit,	[lsl],				[lower_sensor_limit_help];
		MINIMUM_SPAN,			sensor_minimum_span,	[minimum_span],	[minimum_span_help];
		DAMPING_VALUE,			sensor_damping_value,[damping_value],	[seconds_damping_value_help];

/* Analog Output Information */
		ANALOG_VALUE,			analog_value,			[analog_output_value],	[analog_value_help];
		ALARM_CODE,				analog_alarm_code,	[alarm_select],			[alarm_code_help];

/* Input Information */
		PERCENT_RANGE,			input_percent_range,			[pv_percent_range],	[percent_of_range_help];
		TRANSFER_FUNCTION,	input_transfer_function,	[transfer_function],	[transfer_function_help];
		UPPER_RANGE_VALUE,	input_upper_value,			[urv],					[upper_range_value_help];
		LOWER_RANGE_VALUE,	input_lower_value,			[lrv],					[lower_range_value_help];

/* Device Information */
		SENSOR_SERIAL_NUMBER,	sensor_serial_number,	[sensor_serial_number], [sensor_serial_number_help];
	}
}



/* DEFINING METHODS */
METHOD loop_test
{
	LABEL [loop_test];

	HELP [loop_test_help];

	DEFINITION
	{
		char status[STATUS_SIZE];
		int choice;
		long var_id[1];
		int use_abort_method;
		char disp_string1[60];
		char disp_string2[60];
		int slen1;
		int slen2;

		slen1=60;
		slen2=60;
		get_dictionary_string(remove_loop_from_auto,disp_string1,slen1);
		ACKNOWLEDGE(disp_string1);
		add_abort_method(return_to_normal);

		IGNORE_ALL_RESPONSE_CODES();

		use_abort_method = 0;
		do {
			get_dictionary_string(choose_analog_output_level,disp_string1,slen1);
			get_dictionary_string(choices_4_20_other_end,disp_string2,slen2);
			choice = SELECT_FROM_LIST(disp_string1, disp_string2);
			switch ( choice ) {
			case 0:
				assign_float(analog_value,4.0);
				break;

			case 1:
				assign_float(analog_value,20.0);
				break;

			case 2:
				get_dictionary_string(loop_output,disp_string1,slen1);
				GET_DEV_VAR_VALUE(disp_string1, analog_value);
				break;

			case 3:
			default:
				process_abort();
				break;
			}
			send(40,status);
			if (!use_abort_method) {
				if (( status[STATUS_RESPONSE_CODE] != 0)
						&& ( status[STATUS_RESPONSE_CODE] != 3)
						&& ( status[STATUS_RESPONSE_CODE] != 4)) {
					display_response_status(40,status[STATUS_RESPONSE_CODE]);
					get_dictionary_string(abort_last_error,disp_string1,slen1);
					DELAY(2,disp_string1);
					process_abort();
				}
				remove_abort_method(return_to_normal);
				add_abort_method(leave_fixed_current_mode);
				use_abort_method =1;
			}
			if ( status[STATUS_RESPONSE_CODE] ) {
				display_response_status(40,status[STATUS_RESPONSE_CODE]);
				if (( status[STATUS_RESPONSE_CODE] != 3)
						&& ( status[STATUS_RESPONSE_CODE] != 4)) {
					get_dictionary_string(abort_last_error,disp_string1,slen1);
					DELAY(2,disp_string1);
					process_abort();
				}
			}
			else {
				var_id[0] = VARID(analog_value);
				get_dictionary_string(fld_dev_otpt_fixed,disp_string1,slen1);
				acknowledge(disp_string1,var_id);
			}
		} while ( choice < 3);
		process_abort();
	}
}



METHOD leave_fixed_current_mode
{
	LABEL [leaving_fixed_current_mode];

	HELP [leaving_fixed_current_mode_help_2];

	DEFINITION
	{
		char status[STATUS_SIZE];
		long var_id[1];
		char disp_string1[60];
		int slen1;

		slen1 =60;

		assign_float(analog_value,0.0);
		IGNORE_ALL_RESPONSE_CODES();
		do {
			get_dictionary_string(return_fld_dev_to_orig_otpt,disp_string1,slen1);
			DELAY(3,disp_string1);
			send(40,status);
			if ( status[STATUS_RESPONSE_CODE] ) {
				display_response_status(40,status[STATUS_RESPONSE_CODE]);
			}
		} while ( status[STATUS_RESPONSE_CODE]);
		get_dictionary_string(loop_may_be_returned_to_auto,disp_string1,slen1);
		ACKNOWLEDGE(disp_string1);
	}
}


METHOD return_to_normal
{
	LABEL [aborting_return_to_normal];
	DEFINITION
	{
		char disp_string1[60];
		int slen1;

		slen1 =60;
		get_dictionary_string(loop_may_be_returned_to_auto,disp_string1,slen1);
		ACKNOWLEDGE(disp_string1);
	}
}

METHOD reset_config_flag
{
	LABEL "Reset Configuration Flag";
	DEFINITION
	{
		char status[STATUS_SIZE];
        char disp_string1[60];
        int slen1;
        slen1 = 60;
		
		IGNORE_ALL_DEVICE_STATUS();
        IGNORE_ALL_RESPONSE_CODES();
        XMTR_IGNORE_ALL_DEVICE_STATUS();
        XMTR_IGNORE_ALL_RESPONSE_CODES();
		
		send(38, status);
		if ( status[STATUS_RESPONSE_CODE] )
		{
			display_response_status(38,status[STATUS_RESPONSE_CODE]);
			get_dictionary_string(abort_last_error, disp_string1, slen1); 
			DELAY(2, disp_string1);
			process_abort();
		}
		ACKNOWLEDGE("Method Completed");
	}
}

#include "KLAY_PDM_HART_MENU.inc"

