/*

		DEVICE DESCRIPTION FOR KLAY SERIES 2000 AND SERIES 2000 SAN


		Date:			14-05-2001
		Author:		M.M. van de Belt
		Company:		Klay Instruments b.v. The Netherlands
		Filepath:	d:\siemens\pdm\sim_pdm\devices\hart\hcf\ef\0101\75EF00101.DDL

		Comment:		This files descripbes variables, method and
						menus specialliy written for the SIMATIC PDM.
*/



/*
	Defining WRITE AS ONE
*/
WRITE_AS_ONE range_wao
{
	input_lower_value,	/* variable */
	input_upper_value		/* variable */
}

UNIT sensor_units_relation
{
	sensor_units:
	sensor_value,
   input_lower_value,
   input_upper_value,
	sensor_upper_limit,
	sensor_lower_limit,
	sensor_minimum_span,
	maximum_span,
	current_span
}


UNIT temperature_units_relation
{
	temperature_units:
	proces_temp_value,
	housing_temp_value
}




REFRESH pv_unit_refresh
{
	sensor_units:
	input_upper_value,
	input_lower_value,
   sensor_upper_limit,
	sensor_lower_limit,
	sensor_minimum_span,
	maximum_span,
	current_span
}




/*ARRAY OF VARIABLE loop_warning_variables
{
	ELEMENTS
	{
		1, input_lower_value;
		2,	input_upper_value;
		3,	sensor_damping_value;
		4,	input_transfer_function;
	}
} */



/* Variable is not in any command, but defined for method */
/* Definition for bargraphlimits */
VARIABLE temp_lower_value
{
	HELP [lower_range_value_help];
	LABEL [pv_lrv];
	CLASS LOCAL;
	TYPE FLOAT
	{
		DEFAULT_VALUE -20.;
	}
}


/* Definition for bargraphlimits */
VARIABLE temp_upper_value
{
	HELP [lower_range_value_help];
	LABEL [pv_lrv];
	CLASS LOCAL;
	TYPE FLOAT
	{
		DEFAULT_VALUE 100.;
	}
}


/*	Define variable of transfer_function, special defined for representation
	of text in PDM. This looks much nicer than the HC275-representation */
VARIABLE input_transfer_function
{
	HELP [transfer_function_help];
	CLASS INPUT;
	LABEL "Transfer Function";
	HANDLING READ & WRITE;
	TYPE ENUMERATED
	{
		{0, "Normal 4-20 mA""|de|Normal 4-20 mA","No lineairisations""|de|Kein linearisation"},
		{1, "Cylindrical tank""|de|Zylindischer Tank","Lineairization for horizontal tank, hectoliter readout is possible""Linearisation fr zylindrischer Tank, Hectoliter Anzeige ist mglich" },
		{2, "V. tank (cone)""|de|Tank mit kon Boden", "Lineairization for vertical tank (with cone), hectoliter readout is possible""|de|Linearisation fr Tank mit konischer Boden, Hectoliter Anzeige ist mglich"},
		{3, "V. tank (sphere)""|de|Tank mit runden Boden", "Lineairization for vertical tank (with spherical cone), hectoliter readout is possible""|de|Linearisation fr Tank mit runden Boden, Hectoliter Anzeige ist mglich"}
	}
}


/* Variable is not in any command, but defined for method */
VARIABLE percent_of_height
{
	HELP "Percentage used of tankheight";
	CLASS CORRECTION;
	LABEL "Percentage of tankheight""|de|Prozentsatz von Tankhhe";
	CONSTANT_UNIT [Percent];
	TYPE FLOAT
	{
		DEFAULT_VALUE 100.;
      MAX_VALUE 100.;
		DISPLAY_FORMAT ".2f";
	}
}



/* Special definition for PDM */
VARIABLE levelpercent
{
	CLASS CORRECTION;
	LABEL "Percentage of tankheight""|de|Prozentsatz von Tankhhe";
	HELP "";
	HANDLING READ & WRITE;
	CONSTANT_UNIT [Percent];
	TYPE FLOAT
	{
		DEFAULT_VALUE 100.;
		MIN_VALUE  50.;
		MAX_VALUE  100.;
		DISPLAY_FORMAT "5.1f";
		EDIT_FORMAT "5.1f";
	}
}


/* Special definition for representation in PDM */
COLLECTION OF VARIABLE SV
{
	LABEL [sv];
	HELP [secondary_variable_help];
	MEMBERS
	{
		/* Sensor Correction Information */
		DIGITAL_UNITS,			temperature_units,			[units],			[digital_units_help];
		DIGITAL_VALUE,			proces_temp_value,			"Proces temperature",			[blank]/*[digital_value_help]*/;
	}
}


/* Special definition for representation in PDM */
COLLECTION OF VARIABLE TV
{
	LABEL [tv];
	HELP [tertiary_variable_help];
	MEMBERS
	{
		DIGITAL_UNITS,			temperature_units,			[units],			[digital_units_help];
		DIGITAL_VALUE,			housing_temp_value,			"Ambient temperature",			[blank];
	}
}


/* Special definition for representation in PDM */
COLLECTION OF VARIABLE QV
{
	LABEL [tv];
	HELP [tertiary_variable_help];
	MEMBERS
	{
		DIGITAL_UNITS,			lin_units,				[units],				[digital_units_help];
		DIGITAL_VALUE,			hecto_value,			"Volume",		[blank];
	}
}




/* Needed for Simatic PDM */
#include "SI_HlpM.inc"
#include "SI_FileM.inc"
#include "SI_OptM.inc"
#include "SIHA.inc"


/*
	MENU-definition for Siemens PDM
*/


/* SPECIALIST maintable */
MENU Table_Main_Specialist
{
	LABEL	"Klay 2000 Series (Specialist-mode)";
	ITEMS
	{
		Tab_s_ident,       	 /* sub table */
		Tab_s_input,          /* sub table */
		Tab_s_output,         /* sub table */
		Tab_s_device,         /* sub table */
      Tab_s_hart		 		 /* sub table */
	}
}


/* Specialist iedentification table */
MENU Tab_s_ident
{
	LABEL	[menu_ident];
	ITEMS
	{
		Tab_s_ident_opunit,	/* sub table */
		Tab_s_ident_device  	/* sub table */
	}
}


/* definition identification subtable */
MENU Tab_s_ident_opunit
{
	LABEL [menu_ident_opunit];
	ITEMS
	{
		tag,						 /* variable */
		descriptor,           /* variable */
		message               /* variable */
	}
}


/* Defining identification subtable */
MENU Tab_s_ident_device
{
	LABEL [menu_ident_device];
	ITEMS
	{
		manufacturer_id (READ_ONLY),					/* variable */
		device_type (READ_ONLY),        				/* variable */
		device_id (READ_ONLY),          				/* variable */
		private_label_distributor (READ_ONLY),    /* variable */
		universal_revision (READ_ONLY),           /* variable */
		transmitter_revision (READ_ONLY),         /* variable */
		software_revision (READ_ONLY),            /* variable */
		hardware_revision (READ_ONLY),            /* variable */
      physical_signaling_code (READ_ONLY),      /* variable */
		final_assembly_number(READ_ONLY),			/* variable */
		klay_typecode (READ_ONLY),                /* variable */
		sensor_serial_number (READ_ONLY),         /* variable */
		date                                      /* variable */
	}
}



/* Defining input table */
MENU Tab_s_input
{
	LABEL [menu_input];
	ITEMS
	{
		sensor_units,         		/* variable */
		temperature_units,    		/* variable */
		Tab_s_input_measrange,    	/* sub-table */
		Tab_s_input_measwindow		/* sub-table */
	}
}



/* Definition measuring range limits table */
MENU Tab_s_input_measrange
{
	LABEL [menu_input_measrange];
	ITEMS
	{
		sensor_upper_limit (READ_ONLY),
      sensor_lower_limit (READ_ONLY),
		maximum_span (READ_ONLY),           /* variable */
		sensor_minimum_span (READ_ONLY)     /* variable */
	}
}



/* Defining measuring range adjustments table */
MENU Tab_s_input_measwindow
{
	LABEL [menu_input_measwindow];
	ITEMS
	{
		input_lower_value
      input_upper_value
	}
}



/* Defining outputadjustments table */
MENU Tab_s_output
{
	LABEL [menu_output];
	ITEMS
	{
		Tab_s_damping,            /* sub-table */
      Tab_s_lin					  /* sub-table */
   }
}




MENU Tab_s_damping
{
	LABEL "Damping";
   ITEMS
   {
		sensor_damping_value
	}
}




MENU Tab_s_lin
{
	LABEL "Linearization";
	ITEMS
   {
		reverse_output,           /* variable */
		input_transfer_function,  /* variable */
		h1,                       /* variable */
		h2_d,                     /* variable */
		h2_l,                     /* variable */
		h3,                       /* variable */
		levelpercent,             /* variable */
		density_factor            /* variable */
	}
}




/* Definition Device table */
MENU Tab_s_device
{
	LABEL "Device" "|de|Feldgert";
	ITEMS
	{
		Tab_s_humaninterface,     /* sub-table */
		Tab_s_construction        /* sub-table */
	}
}




/* Definition humaninterface table */
MENU Tab_s_humaninterface
{
	LABEL "Human interface";
	ITEMS
	{
		display_readout,			/* variable */
		write_protect,          /* variable */
		local_write_protect     /* variable */
	}
}





/* Definition construction table */
MENU Tab_s_construction
{
	LABEL "Transmitter construction";
	ITEMS
	{
		diaphragm_material (READ_ONLY),	 /* variable */
		o_ring_material (READ_ONLY)       /* variable */
	}
}





MENU Tab_s_hart
{
	LABEL "HART";
   ITEMS
   {
      request_preambles (READ_ONLY)		/* variable */
   }
}



/* MAINTENANCE table */
MENU Table_Main_Maintenance

{
	LABEL	"Klay 2000 Series (Maintenance-mode)";
	ITEMS
	{
		Tab_m_ident  			/* sub-table */
	}
}



/* Definition identification table */
MENU Tab_m_ident
{
	LABEL	[menu_ident];
	ITEMS
	{
		Tab_m_ident_opunit,				/* sub-table */
		Tab_m_ident_device        		/* sub-table */
	}
}




/* Definition identification table */
MENU Tab_m_ident_opunit
{
	LABEL [menu_ident_opunit];
	ITEMS
	{
		tag (READ_ONLY),			  /* variable */
		descriptor,               /* variable */
		message                   /* variable */
	}
}





/* Definition identification data table */
MENU Tab_m_ident_device
{
	LABEL [menu_ident_device];
	ITEMS
	{
		manufacturer_id (READ_ONLY),             /* variable */
		device_type (READ_ONLY),                 /* variable */
		device_id (READ_ONLY),                   /* variable */
		private_label_distributor (READ_ONLY),   /* variable */
		universal_revision (READ_ONLY),          /* variable */
		transmitter_revision (READ_ONLY),        /* variable */
		software_revision (READ_ONLY),           /* variable */
		hardware_revision (READ_ONLY),           /* variable */
		final_assembly_number (READ_ONLY),       /* variable */
		klay_typecode (READ_ONLY),               /* variable */
		sensor_serial_number (READ_ONLY),        /* variable */
		date
	}
}






/* Definition menus for specialist */
MENU Menu_Main_Specialist
{
	LABEL "Klay Instruments";
	ITEMS
	{
		Menu_File,
		Menu_S_Device,
		Menu_View,
		Menu_Options,
		Menu_Help
	}
}



/* Definition DDevice menu for specialist */
MENU Menu_S_Device
{
	LABEL [menu_Device];
	ITEMS
	{
		std_CommWay,								/* Standard PDM Method */
		SEPARATOR,									/* Standard PDM Method */
		std_LoadinDevice, 						/* Standard PDM Method */
		std_LoadinPC,       						/* Standard PDM Method */
		SEPARATOR,          						/* Standard PDM Method */
		OnlineDialog_Device_NodeAddress,		/* Standard PDM Method */
		SEPARATOR,          						/* Standard PDM Method */
		menu_units,                         /*	KLAY menu */
      menu_calibration,                   /*	KLAY menu */
		SEPARATOR,          						/* Standard PDM Method */
      menu_output,								/*	KLAY menu */
		SEPARATOR,          						/* Standard PDM Method */
      OnlineWindow_menu_write_protection,					/*	KLAY menu */
		loop_test,									/* KLAY Method */
		SEPARATOR,          						/* Standard PDM Method */
		reset_config_flag                           /* KLAY Method */
	}
}



MENU menu_units
{
	LABEL "Units";
   ITEMS
   {
   	OnlineWindow_hart_pressure_unit,			/* KLAY Method */
      OnlineWindow_hart_temperature_unit		/* KLAY Method */
   }
}



MENU OnlineWindow_hart_pressure_unit{
	LABEL [klay_set_pressure_units];

	HELP "Change units of Pressure Value""|de|Druck Einheiten Aendern";

   ITEMS
   {
		Page_pressure_unit
   }
}

MENU OnlineWindow_hart_temperature_unit{
	LABEL [klay_set_temp_unit];

	HELP "Change units of Pressure Value""|de|Druck Einheiten Aendern";

   ITEMS
   {
		Page_temperature_unit
   }
}

MENU Page_pressure_unit
{
	LABEL [klay_pressure_unit];
   ITEMS
   {
		sensor_units,
      SEPARATOR,
   	pdm_set_pressure_units,
   }
}

MENU Page_temperature_unit
{
	LABEL [klay_temperature_unit];
   ITEMS
   {
   	temperature_units,
      SEPARATOR,
   	pdm_set_temperature_units,
   }
}





MENU menu_calibration
{
	LABEL "Calibration";
   ITEMS
   {
   	OnlineWindow_menu_cancel_mounting_position,          	/* KLAY Method */
		OnlineWindow_menu_online_calibration,
      OnlineWindow_menu_offline_calibration
   }
}


MENU OnlineWindow_menu_cancel_mounting_position
{
	LABEL [klay_set_cancel_mounting];
	HELP "All Klay transmitters are calibrated horizontally. When a transmitter of the Series 2000 is installed vertically, there will be a small mounting effect on the zero (4 mA). For example the transmitter shows 4.03 mA instead of 4.00 mA.	This can be easily canceled with this correction"
				"|de|Alle Transmitter der Serie 2000 sind fr den horizontalen Einbau kalibriert. Sollte ein Transmitter vertikal eingebaut werden mssen, kann durch Anwahl dieses Kommandos automatisch die Justierung wieder auf 4.00 mA hergestellt werden.";

	ITEMS
   {
   	Page_cancel_mounting_position,
   }
}

MENU Page_cancel_mounting_position
{
   LABEL [klay_cancel_mounting_pos];

   ITEMS
   {
   	set_cancel_mounting_position,
      SEPARATOR,
      cancel_mounting_position,
   }
}


MENU menu_output
{
	LABEL "Output";
   ITEMS
   {
		OnlineWindow_pdm_set_damping_value,             	/* KLAY Method */
		OnlineWindow_set_density_factor,                	/* KLAY Method */
      OnlineWindow_pdm_set_reverse_output,					/* KLAY Method */
		OnlineWindow_menu_linearizations,						/* Sub menu */
		OnlineWindow_set_display_readout,            /* KLAY Method */
      klay_dac_trim,                     	/* KLAY Method */
   }
}



MENU OnlineWindow_set_display_readout
{
	LABEL [klay_display_readout];

   ITEMS
   {
   	Page_set_display_readout,
   }
}

MENU Page_set_display_readout
{
	LABEL "Display readout";

   ITEMS
   {
   	display_readout,
      SEPARATOR,
      pdm_set_display_readout,
   }
}



MENU OnlineWindow_pdm_set_reverse_output
{
	LABEL [klay_set_reverse_output];

   ITEMS
   {
   	Page_set_reverse_output,
   }
}

MENU Page_set_reverse_output
{
	LABEL "Reverse output";

   ITEMS
   {
      reverse_output,
      SEPARATOR,
      pdm_set_reverse_output,
   }
}


MENU OnlineWindow_set_density_factor
{
	LABEL [klay_density_factor];

   ITEMS
   {
 		Page_set_density_factor,
   }
}

MENU Page_set_density_factor
{
	LABEL "Density factor";

   ITEMS
   {
   	density_factor,
      SEPARATOR,
      set_density_factor,
   }
}

MENU OnlineWindow_pdm_set_damping_value
{
	LABEL [klay_set_damping];

   ITEMS
   {
		Page_set_damping,
   }
}


MENU Page_set_damping
{
	LABEL "Damping";

   ITEMS
   {
   	sensor_damping_value,
      SEPARATOR,
      pdm_set_damping_value,
   }
}


MENU OnlineWindow_menu_linearizations
{
	LABEL "Linearizations";
   ITEMS
   {
   	Page_pdm_lin,								/* KLAY Method */
   }
}


MENU Page_pdm_lin
{
	LABEL "Linearization:";
   ITEMS
   {
   	Group_transfer_function,
      Group_lin_data,
      pdm_set_lin,
   }
}

MENU Group_transfer_function
{
 	LABEL "Transfer function:";

   ITEMS
   {
   	input_transfer_function,
   }
}

MENU Group_lin_data
{
	LABEL "Linearization data:";

   ITEMS
   {
   	h1,
      h2_l,
      levelpercent,
      SEPARATOR,
      h2_d,
      h3,
   }
	VALIDITY IF (input_transfer_function==0)
	{
		FALSE;
	}
	ELSE
	{
		TRUE;
	}


}


MENU OnlineWindow_menu_write_protection
{
	LABEL "Write Protection";
   ITEMS
   {
      Page_wp,
   }
}



MENU Page_wp
{
	LABEL "Write Protection";
   ITEMS
   {
		Group_menu_local_write_protection,           /* KLAY Method */
      pdm_send_local_wp,
      Group_menu_comm_write_protection,
      pdm_send_wp,
   }
}




MENU Group_menu_local_write_protection
{
	LABEL "Write protection for local indicator""|de|Schreibschutz fr lokale Eingabe";
   ITEMS
   {
		local_write_protect,
      SEPARATOR,
//      pdm_send_local_wp,
   }
}



MENU Group_menu_comm_write_protection
{
	LABEL "Write protection for communications""|de|Schreibschutz fr Kommunication";
   ITEMS
   {
		write_protect,
      SEPARATOR,
//      pdm_send_wp,
   }
}




MENU	OnlineWindow_menu_online_calibration
{
	LABEL "Online Calibration";
   ITEMS
   {
   	Page_pdm_applied_zero,
   	Page_pdm_applied_span
   }
}


MENU Page_pdm_applied_zero
{
	LABEL "Adjust zero";
   ITEMS
   {
   	Group_range_data,
      Group_current_range_data,
      Group_zero_applied,
      SEPARATOR,
   }
}

MENU Group_zero_applied
{
	LABEL "Lower range (4 mA):";
   ITEMS
   {
   	sensor_value,
      SEPARATOR,
      pdm_applied_zero,
   }
}

MENU Page_pdm_applied_span
{
	LABEL "Adjust span";
   ITEMS
   {
   	Group_range_data,
      Group_current_range_data,
      Group_span_applied,
      SEPARATOR,
   }
}

MENU Group_span_applied
{
	LABEL "Upper range (20 mA):";
   ITEMS
   {
   	sensor_value,
      SEPARATOR,
      pdm_applied_span,
   }
}



MENU OnlineWindow_menu_offline_calibration
{
	LABEL	"Offline calibration";
   ITEMS
   {
			Page_zero_enter,
			Page_span_enter,
	}
}


MENU Page_zero_enter
{
	LABEL	"Adjust zero";
   ITEMS
	{
   	Group_range_data,
      Group_current_range_data,
      Group_zero_enter,
		SEPARATOR,
   }
}

MENU Page_span_enter
{
	LABEL	"Adjust span";
   ITEMS
	{
   	Group_range_data,
      Group_current_range_data,
      Group_span_enter,
      SEPARATOR,
   }
}

MENU Group_range_data
{
	LABEL "Transmitter limits:";
   ITEMS
   {
		sensor_minimum_span,
      maximum_span,
      SEPARATOR,
      sensor_lower_limit,
      sensor_upper_limit,
   }
}

MENU Group_current_range_data
{
	LABEL "Current range:";
   ITEMS
   {
   	input_lower_value (READ_ONLY),
      SEPARATOR,
   	input_upper_value (READ_ONLY),
   }
}

MENU Group_zero_enter
{
	LABEL "Lower range value";
   ITEMS
   {
    	input_lower_value,
      SEPARATOR,
		pdm_zero_enter,			/* Method */
   }
}

MENU Group_span_enter
{
	LABEL "Upper range value";
   ITEMS
   {
    	input_upper_value,
      SEPARATOR,
		pdm_span_enter,			/* Method */
   }
}





/* Definition View menu */
MENU Menu_View
{
	LABEL [menu_View];
	ITEMS
	{
		OnlineWindow_display, 			/* Method */
		SEPARATOR,                  	/* Standard PDM Method */
		OnlineWindow_yt,            	/* Method */
    	OnlineWindow_device_info,
		SEPARATOR,                  	/* Standard PDM Method */
		std_Funktionsleiste,        	/* Standard PDM Method */
		std_Statuszeile,            	/* Standard PDM Method */
		SEPARATOR,                  	/* Standard PDM Method */
		std_Update							/* Standard PDM Method */
	}
}




MENU OnlineWindow_device_info
{
	LABEL "Device info";
   ITEMS
   {
		tag (READ_ONLY),
      manufacturer_id,
      device_id,
      device_type,
      software_revision,
      hardware_revision,
      transmitter_revision,
      universal_revision
   }
}


/* Definition display window */
MENU OnlineWindow_display
{
	LABEL [menu_dialog_display];
	ITEMS
	{
		BarValueDisplay		/* Method */
	}
}



/* Definiton BarGraph display */
MENU BarValueDisplay
{
	LABEL "Online value display";
	ITEMS
	{
		BarVal_PV,							/* Method */
		Val_procentView,              /* Method */
		Val_AnalogView,               /* Method */
		device_status(READ_ONLY),     /* Variable */
		proces_temp_value,             /* Variable */
		housing_temp_value              /* Variable */
	}
}



/* BarGraph for PV-value */
MENU BarVal_PV
{
	LABEL [menu_dialog_display_measure];
	LABEL "Measuring Value";
	ITEMS
	{
		sensor_value (READ_ONLY),			/* Variable */
		input_lower_value (READ_ONLY), /* Variable */
		input_upper_value (READ_ONLY)  /* Variable */
	}
}



/* BarGraph for percent of range value */
MENU Val_procentView
{
	LABEL "Percent of range";
	HELP	[percent_of_range_help];
	ITEMS
	{
		input_percent_range(READ_ONLY)	/* Variable */
	}
}



/* BarGraph for analog output value */
MENU Val_AnalogView
{
	LABEL "Analog output";
	ITEMS
	{
		analog_value					/* Variable */
	}
}



#define YT1_LABEL [sensor_value]
	#define YT1_VALUE	sensor_value
	#define YT1_LRV input_lower_value
	#define YT1_URV input_upper_value
#define YT2_LABEL "Procestemperature"
	#define YT2_VALUE proces_temp_value
	#define YT2_LRV temp_lower_value
	#define YT2_URV temp_upper_value
#include "SI_YT.inc"




/* List of download variables */
MENU download_variables
{
		LABEL   [menu_load_to_PC];

		ITEMS
		{
			tag,
			descriptor,
			message,
			final_assembly_number,
			manufacturer_id,
			device_id,
			device_type,
			device_flags,
			software_revision,
			hardware_revision,
			physical_signaling_code,
			transmitter_revision,
			universal_revision,
			request_preambles,
			write_protect,
			date,
			input_transfer_function,
			private_label_distributor,
			sensor_units,
			sensor_value,
			sensor_upper_limit,
			sensor_lower_limit,
			sensor_minimum_span,
			sensor_damping_value,
			analog_value,
			analog_alarm_code,
			input_percent_range,
			input_transfer_function,
			input_upper_value,
			input_lower_value,
			sensor_serial_number,
			temperature_units,
			proces_temp_value,
			housing_temp_value,
			klay_typecode,
			local_write_protect,
			display_readout,
			reverse_output,
			maximum_span,
			diaphragm_material,
			o_ring_material,
			h1,
			h2_d,
			h2_l,
			h3,
			h4,
			levelpercent,
			density_factor
		}
}



/* Definition upload variables */
MENU upload_variables /* Write to device */
{
		LABEL		[menu_load_to_device];
		ITEMS
		{
			date,
			tag,
			descriptor,
			message,
			final_assembly_number,
			write_protect,
			input_transfer_function,
			sensor_units,
			sensor_damping_value,
			temperature_units,
			local_write_protect,
			display_readout,
			reverse_output,
			input_upper_value,
			input_lower_value,
			h1,
			h2_d,
			h2_l,
			h3,
			h4,
			levelpercent,
			density_factor
		}
}




/* Definition maintenance main menu */
MENU Menu_Main_Maintenance
{
	LABEL "Klay Instruments";
	ITEMS
	{
		Menu_File,
		Menu_M_Device,
		Menu_View,
		Menu_Options,
		Menu_Help
	}
}



/* Definiton Device menu */
MENU Menu_M_Device
{
	LABEL [menu_Device];
	ITEMS
	{
		std_CommWay,								/* Standard PDM Method */
		SEPARATOR,									/* Standard PDM Method */
		std_LoadinDevice, 						/* Standard PDM Method */
		std_LoadinPC       						/* Standard PDM Method */
	}
}





METHOD pdm_send_local_wp
{
	LABEL [transfer];
	HELP [write_protect_mode_help];


	DEFINITION
	{
		char status[STATUS_SIZE];

		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
      send(161,status);
      if (status[STATUS_RESPONSE_CODE]){
			display_response_status(161,status[STATUS_RESPONSE_CODE]);
      }
	}
}

METHOD pdm_send_wp
{
	LABEL [transfer];
	HELP [write_protect_mode_help];


	DEFINITION
	{
		char status[STATUS_SIZE];

		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
      send(161,status);
      if (status[STATUS_RESPONSE_CODE]){
			display_response_status(161,status[STATUS_RESPONSE_CODE]);
      }
	}
}





METHOD pdm_set_reverse_output
{
	LABEL [klay_set_reverse_output];

	HELP "Change output""|de|Ausgang Aendern";

	DEFINITION
	{
		char status[STATUS_SIZE];

		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		send(152,status);
		if (status[STATUS_RESPONSE_CODE]){
			display_response_status(152,status[STATUS_RESPONSE_CODE]);
			iassign(reverse_output,old_unit);
		}
	}
}



/*
	Method set pressure units
*/
METHOD pdm_set_pressure_units
{
	LABEL [transfer];

	HELP "Change units of Pressure Value""|de|Druck Einheiten Aendern";

	DEFINITION
	{
		char status[STATUS_SIZE];

		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		/* Read current units */
		/* Send new units */
		send(44,status);
		if (status[STATUS_RESPONSE_CODE]){
			display_response_status(44,status[STATUS_RESPONSE_CODE]);
			iassign(sensor_units,old_unit);
		}
	}
}





/*
	Method set temperature units
*/
METHOD pdm_set_temperature_units
{
	LABEL [transfer];

	HELP "Change units of Temperature Value""|de|Temperatur Einheiten Aendern";

	DEFINITION
	{
		char status[STATUS_SIZE];
		int rev;

		rev =int_value(software_revision);
		if (rev>4){
			IGNORE_ALL_RESPONSE_CODES();
			IGNORE_ALL_DEVICE_STATUS();
			XMTR_IGNORE_ALL_RESPONSE_CODES();
			XMTR_IGNORE_ALL_DEVICE_STATUS();
			/* Read current units */
			/* Send new units */
			send(155,status);
			if (status[STATUS_RESPONSE_CODE]){
				display_response_status(155,status[STATUS_RESPONSE_CODE]);
				iassign(temperature_units,old_unit);
			}
		}
		else {
			PUT_MESSAGE("Not possible, old software revision!!");
			DELAY_TIME(2);
		}
	}
}





/* Method set damping value */
METHOD pdm_set_damping_value
{
	LABEL [klay_set_damping];

	HELP "Set damping value.\n\n\n\n0 <= Damping <= 25""|de|Einstellen Dmpfungs Wert.\n\n\n\n0 <= Dmpfung <= 25";

	DEFINITION
	{
		char status[STATUS_SIZE];

		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		/* Send damping value */
		send(34,status);
		if (status[STATUS_RESPONSE_CODE]){
			display_response_status(34,status[STATUS_RESPONSE_CODE]);
			fassign(sensor_damping_value,old_damping);
		}
	}
}





/*
	Method for density factor
*/
METHOD set_density_factor
{
	LABEL [klay_density_factor]; //"Density Factor""|de|Spezifisches Gewicht";


	DEFINITION
	{

		char status[STATUS_SIZE];

		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_ALL_DEVICE_STATUS();

		/* Send variables */
		send(153,status);
		if (status[STATUS_RESPONSE_CODE]){
			/* reset values if error */
			display_response_status(153,status[STATUS_RESPONSE_CODE]);
		}
	}
}




/* Calibrate zero with testpressure */
METHOD pdm_applied_zero
{
	LABEL [klay_adjust_zero_test];
	HELP 	"Applied values- Perform a device rerange by applying the desired Span(URV-LRV) and Zero(LRV) to the device input."
				"|fr|Valeurs appliques- Redfinit l'chelle de l'instrument en appliquant  l'entre de l'instrument les valeurs correspondant aux valeurs haute et basse de l'chelle."
				"|de|Angelegte Werte- Ausfhrung einer Neueinstellung durch Anlegen der bentigten Werte fr den Meanfng und das Meende auf den Prozeeingang des Gertes."
				"|kt|zitu nyuuryoku - debaisuno rennzihennkouwo .b.Upper .e.rennzitito .b.Lower .e.rennzitino ziltusainonyuuryokude okonaimasu.";

	DEFINITION
	{
		char status[STATUS_SIZE];

		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		/* Apply 4 mA pressure */
		send(37,status);
		if ( status[STATUS_RESPONSE_CODE] ) {
			display_response_status(37,status[STATUS_RESPONSE_CODE]);
		}
	}
}


/* Calibrate span with testpressure */
METHOD pdm_applied_span
{
	LABEL [klay_adjust_span_test];
	HELP 	"Applied values- Perform a device rerange by applying the desired Span(URV-LRV) and Zero(LRV) to the device input."
				"|fr|Valeurs appliques- Redfinit l'chelle de l'instrument en appliquant  l'entre de l'instrument les valeurs correspondant aux valeurs haute et basse de l'chelle."
				"|de|Angelegte Werte- Ausfhrung einer Neueinstellung durch Anlegen der bentigten Werte fr den Meanfng und das Meende auf den Prozeeingang des Gertes."
				"|kt|zitu nyuuryoku - debaisuno rennzihennkouwo .b.Upper .e.rennzitito .b.Lower .e.rennzitino ziltusainonyuuryokude okonaimasu.";

	DEFINITION
	{
		char status[STATUS_SIZE];

		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		/* Apply 20 mA pressure */
		send(36,status);
		if ( status[STATUS_RESPONSE_CODE] ) {
			display_response_status(36,status[STATUS_RESPONSE_CODE]);
		}
	}
}



/* Method enter zero without reference */
METHOD pdm_zero_enter
{
	LABEL [klay_enter_zero_no_test];

	HELP "Adjust Zero (4 mA)""|de|Nullpunktjustierung (4 mA)";

	DEFINITION
	{
		char status[STATUS_SIZE];

		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		/* Send new zero */
		send(35,status);
		if (status[STATUS_RESPONSE_CODE]){
        	display_response_status(35,status[STATUS_RESPONSE_CODE]);
		}
	}
}



/* Method enter span without reference */
METHOD pdm_span_enter
{
	LABEL [klay_enter_span_no_test];

	HELP "Adjust Span (20 mA)" "|de|Mespannejustierung (20 mA)";

	DEFINITION
	{
		char status[STATUS_SIZE];

		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		send(35,status);
		if (status[STATUS_RESPONSE_CODE]){
       	display_response_status(35,status[STATUS_RESPONSE_CODE]);
		}
	}
}



/* Method for tanklineairisations */
METHOD pdm_set_lin
{
	LABEL [transfer];

/*	HELP "There three kinds of lineairisations, no lineairisation, cilindrical tank and vertical tank with cone"
				"|de|Die Klay 2000 hat drei verschiedene Linearisationen, keine Linearisation, zylindrischer Tank und Tank mit konischem Boden";*/

	DEFINITION
	{

		char status[STATUS_SIZE];

		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		/* Read lineairisation data */
		fassign(h4,0.0);
		/* Send variables */
		send(151,status);
		if (status[STATUS_RESPONSE_CODE]){
				/* reset values if error */
			display_response_status(151,status[STATUS_RESPONSE_CODE]);
		}
		send(154,status);
		if (status[STATUS_RESPONSE_CODE]){
		/* reset values if error */
			display_response_status(154,status[STATUS_RESPONSE_CODE]);
		}
	}
}





/*
	Method set display reading
*/
METHOD pdm_set_display_readout
{
	LABEL [klay_display_readout];

	HELP "The Klay Series 2000 has various readouts for the display."
				"|de|Die Klay 2000 hat verschiedene Anzeigemglichheiten.";

	DEFINITION
	{

		char status[STATUS_SIZE];

		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_ALL_DEVICE_STATUS();

		/* Send new readout */
		send(140,status);
		if (status[STATUS_RESPONSE_CODE]){
			display_response_status(140,status[STATUS_RESPONSE_CODE]);
			iassign(display_readout,varid[0]);
		}
	}
}



/* Definiton method cancel mounting position */
METHOD cancel_mounting_position
{
	LABEL [transfer];
	HELP "All Klay transmitters are calibrated horizontally. When a transmitter of the Series 2000 is installed vertically, there will be a small mounting effect on the zero (4 mA). For example the transmitter shows 4.03 mA instead of 4.00 mA.	This can be easily canceled with this correction"
				"|de|Alle Transmitter der Serie 2000 sind fr den horizontalen Einbau kalibriert. Sollte ein Transmitter vertikal eingebaut werden mssen, kann durch Anwahl dieses Kommandos automatisch die Justierung wieder auf 4.00 mA hergestellt werden.";

	DEFINITION
	{
		int rev;
		char status[STATUS_SIZE];

		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_ALL_DEVICE_STATUS();

		rev =int_value(software_revision);
		if (rev>3){
			IGNORE_ALL_RESPONSE_CODES();
			IGNORE_ALL_DEVICE_STATUS();
			XMTR_IGNORE_ALL_RESPONSE_CODES();
			XMTR_IGNORE_ALL_DEVICE_STATUS();
			send(150,status);
			if (status[STATUS_RESPONSE_CODE]){
				display_response_status(150,status[STATUS_RESPONSE_CODE]);
			}
			iassign(set_cancel_mounting_position,0);
		}
		else {
			PUT_MESSAGE("Not possible, old software revision!!""|de|Nicht mglich, alte Softwarerevision");
			DELAY_TIME(4);
		}
	}
}



METHOD klay_dac_trim
{
	LABEL [DAC_trim];

	HELP [digital_to_analog_trim_help];

		/*	APPHELP "This type of calibration is usually used to compensate for"
							" drifting or aging output electronics";
		*/
	DEFINITION
	{
		int retry;
		char status[STATUS_SIZE];
		long var_ids[2];
		char disp_string1[60];
		char disp_string2[60];
		int slen1;
		int slen2;
		int rev;

		slen1=60;
		slen2=60;
		/* Show warning */
		get_dictionary_string(remove_loop_from_auto,disp_string1,slen1);
		ACKNOWLEDGE(disp_string1);
		add_abort_method(return_to_normal);
		/* Connect your meter */
		get_dictionary_string(connect_reference_meter,disp_string1,slen1);
		ACKNOWLEDGE(disp_string1);

		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();

		/* go to 20 mA */
		var_ids[0] = VARID(analog_value);
		get_dictionary_string(setting_fld_dev_20_ma,disp_string1,slen1);
		ACKNOWLEDGE(disp_string1);
		assign_float(analog_value,20.0);
		send(40,status);

		remove_abort_method(return_to_normal);
		add_abort_method(leave_fixed_current_mode);

		if ( status[STATUS_RESPONSE_CODE]) {
			display_response_status(40,status[STATUS_RESPONSE_CODE]);
			get_dictionary_string(abort_last_error,disp_string1,slen1);
			DELAY(2,disp_string1);
			process_abort();
		}
		DELAY_TIME(1);
		do {
			/* Enter metervalue */
			get_dictionary_string(enter_meter_value,disp_string1,slen1);
			GET_DEV_VAR_VALUE(disp_string1, analog_value);
			send(46,status);
			assign_float(analog_value,20.0);
			if (( status[STATUS_RESPONSE_CODE] == 3 ) || ( status[STATUS_RESPONSE_CODE] == 4)) {
				display_response_status(46,status[STATUS_RESPONSE_CODE]);
				retry = 1;
			}
			else if ( status[STATUS_RESPONSE_CODE]) {
				display_response_status(46,status[STATUS_RESPONSE_CODE]);
				get_dictionary_string(abort_last_error,disp_string1,slen1);
				DELAY(2,disp_string1);
				process_abort();
			}
			else {
				var_ids[0] = VARID(analog_value);
				get_dictionary_string(fld_dev_otpt_equal_ref_meter,disp_string1,slen1);
				get_dictionary_string(yes_no,disp_string2,slen2);
				retry=select_from_list(disp_string1,var_ids,disp_string2);
			}
		} while (retry);

		rev =int_value(software_revision);

		if (rev > 4){
/*			IGNORE_ALL_DEVICE_STATUS();
			IGNORE_ALL_RESPONSE_CODES();
			XMTR_IGNORE_ALL_DEVICE_STATUS();
			XMTR_IGNORE_ALL_RESPONSE_CODES();*/

			var_ids[0] = VARID(analog_value);
			get_dictionary_string(setting_fld_dev_4_ma,disp_string1,slen1);
			ACKNOWLEDGE(disp_string1);
			assign_float(analog_value,4.0);
			send(40,status);

/*			remove_abort_method(return_to_normal);*/
		/*	add_abort_method(leave_fixed_current_mode);*/

			if ( status[STATUS_RESPONSE_CODE]) {
				display_response_status(40,status[STATUS_RESPONSE_CODE]);
				get_dictionary_string(abort_last_error,disp_string1,slen1);
				DELAY(2,disp_string1);
				process_abort();
			}
			DELAY_TIME(2);
			do {
				/* Enter metervalue */
				get_dictionary_string(enter_meter_value,disp_string1,slen1);
				GET_DEV_VAR_VALUE(disp_string1, analog_value);
				send(45,status);
				assign_float(analog_value,4.0);
				if (( status[STATUS_RESPONSE_CODE] == 3 ) || ( status[STATUS_RESPONSE_CODE] == 4)) {
					display_response_status(45,status[STATUS_RESPONSE_CODE]);
					retry = 1;
				}
				else if ( status[STATUS_RESPONSE_CODE]) {
					display_response_status(45,status[STATUS_RESPONSE_CODE]);
					get_dictionary_string(abort_last_error,disp_string1,slen1);
					DELAY(2,disp_string1);
					process_abort();
				}
				else {
					var_ids[0] = VARID(analog_value);
					get_dictionary_string(fld_dev_otpt_equal_ref_meter,disp_string1,slen1);
					get_dictionary_string(yes_no,disp_string2,slen2);
					retry=select_from_list(disp_string1,var_ids,disp_string2);
				}
			} while (retry);
		}
		process_abort();
	}
}





/*
REFRESH lins
{
	h1, h2_d, h2_l, h3, h4, levelpercent:
	input_transfer_function
} */


